/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.rules.PredicateClassLoader;
import com.google.gerrit.rules.PredicateProvider;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.googlecode.prolog_cafe.exceptions.CompileException;
import com.googlecode.prolog_cafe.exceptions.SyntaxException;
import com.googlecode.prolog_cafe.exceptions.TermException;
import com.googlecode.prolog_cafe.lang.BufferingPrologControl;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.RawParseUtils;

@Singleton
public class RulesCache {
    private static final ImmutableList<String> PACKAGE_LIST = ImmutableList.of("com.googlecode.prolog_cafe.builtin", "gerrit");
    private final boolean enableProjectRules;
    private final int maxDbSize;
    private final int maxSrcBytes;
    private final Path cacheDir;
    private final Path rulesDir;
    private final GitRepositoryManager gitMgr;
    private final DynamicSet<PredicateProvider> predicateProviders;
    private final ClassLoader systemLoader;
    private final PrologMachineCopy defaultMachine;
    private final Map<ObjectId, MachineRef> machineCache = new HashMap<ObjectId, MachineRef>();
    private final ReferenceQueue<PrologMachineCopy> dead = new ReferenceQueue();

    @Inject
    protected RulesCache(@GerritServerConfig Config config, SitePaths site, GitRepositoryManager gm, DynamicSet<PredicateProvider> predicateProviders) {
        this.maxDbSize = config.getInt("rules", null, "maxPrologDatabaseSize", 256);
        this.maxSrcBytes = config.getInt("rules", null, "maxSourceBytes", 131072);
        this.enableProjectRules = config.getBoolean("rules", null, "enable", true) && this.maxSrcBytes > 0;
        this.cacheDir = site.resolve(config.getString("cache", null, "directory"));
        this.rulesDir = this.cacheDir != null ? this.cacheDir.resolve("rules") : null;
        this.gitMgr = gm;
        this.predicateProviders = predicateProviders;
        this.systemLoader = this.getClass().getClassLoader();
        this.defaultMachine = PrologMachineCopy.save(this.newEmptyMachine(this.systemLoader));
    }

    public boolean isProjectRulesEnabled() {
        return this.enableProjectRules;
    }

    public synchronized PrologMachineCopy loadMachine(Project.NameKey project, ObjectId rulesId) throws CompileException {
        if (!this.enableProjectRules || project == null || rulesId == null) {
            return this.defaultMachine;
        }
        Reference ref = this.machineCache.get(rulesId);
        if (ref != null) {
            PrologMachineCopy pmc = (PrologMachineCopy)ref.get();
            if (pmc != null) {
                return pmc;
            }
            this.machineCache.remove(rulesId);
            ref.enqueue();
        }
        this.gc();
        PrologMachineCopy pcm = this.createMachine(project, rulesId);
        MachineRef newRef = new MachineRef(rulesId, pcm, this.dead);
        this.machineCache.put(rulesId, newRef);
        return pcm;
    }

    public PrologMachineCopy loadMachine(String name, Reader in) throws CompileException {
        PrologMachineCopy pmc = this.consultRules(name, in);
        if (pmc == null) {
            throw new CompileException("Cannot consult rules from the stream " + name);
        }
        return pmc;
    }

    private void gc() {
        Reference<PrologMachineCopy> ref;
        while ((ref = this.dead.poll()) != null) {
            ObjectId key = ((MachineRef)ref).key;
            if (this.machineCache.get(key) != ref) continue;
            this.machineCache.remove(key);
        }
    }

    private PrologMachineCopy createMachine(Project.NameKey project, ObjectId rulesId) throws CompileException {
        Path jarPath;
        if (this.rulesDir != null && Files.isRegularFile(jarPath = this.rulesDir.resolve("rules-" + rulesId.getName() + ".jar"), new LinkOption[0])) {
            URL[] cp = new URL[]{RulesCache.toURL(jarPath)};
            return PrologMachineCopy.save(this.newEmptyMachine(new URLClassLoader(cp, this.systemLoader)));
        }
        String rules = this.read(project, rulesId);
        PrologMachineCopy pmc = this.consultRules("rules.pl", new StringReader(rules));
        if (pmc == null) {
            throw new CompileException("Cannot consult rules of " + project);
        }
        return pmc;
    }

    private PrologMachineCopy consultRules(String name, Reader rules) throws CompileException {
        BufferingPrologControl ctl = this.newEmptyMachine(this.systemLoader);
        PushbackReader in = new PushbackReader(rules, 3);
        try {
            if (!ctl.execute("com.googlecode.prolog_cafe.builtin", "consult_stream", SymbolTerm.intern(name), new JavaObjectTerm(in))) {
                return null;
            }
        }
        catch (SyntaxException e) {
            throw new CompileException(e.toString(), e);
        }
        catch (TermException e) {
            Term m = e.getMessageTerm();
            if (m instanceof StructureTerm && "syntax_error".equals(m.name()) && m.arity() >= 1) {
                Term at;
                StringBuilder msg = new StringBuilder();
                if (m.arg(0) instanceof ListTerm) {
                    msg.append(Joiner.on(' ').join((Iterable<?>)((ListTerm)m.arg(0)).toJava()));
                } else {
                    msg.append(m.arg(0).toString());
                }
                if (m.arity() == 2 && m.arg(1) instanceof StructureTerm && "at".equals(m.arg(1).name()) && (at = m.arg(1).arg(0).dereference()) instanceof ListTerm) {
                    msg.append(" at: ");
                    msg.append(RulesCache.prettyProlog(at));
                }
                throw new CompileException(msg.toString(), e);
            }
            throw new CompileException("Error while consulting rules from " + name, e);
        }
        catch (RuntimeException e) {
            throw new CompileException("Error while consulting rules from " + name, e);
        }
        return PrologMachineCopy.save(ctl);
    }

    private static String prettyProlog(Term at) {
        StringBuilder b = new StringBuilder();
        Iterator iterator = ((ListTerm)at).toJava().iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (o instanceof Term) {
                Term t = (Term)o;
                if (!(t instanceof StructureTerm)) {
                    b.append(t.toString()).append(' ');
                    continue;
                }
                switch (t.name()) {
                    case "atom": {
                        SymbolTerm atom = (SymbolTerm)t.arg(0);
                        b.append(atom.toString());
                        break;
                    }
                    case "var": {
                        b.append(t.arg(0).toString());
                    }
                }
                continue;
            }
            b.append(o);
        }
        return b.toString().trim();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String read(Project.NameKey project, ObjectId rulesId) throws CompileException {
        try {
            Throwable throwable = null;
            try (Repository git = this.gitMgr.openRepository(project);){
                ObjectLoader ldr = git.open(rulesId, 3);
                byte[] raw = ldr.getCachedBytes(this.maxSrcBytes);
                String string = RawParseUtils.decode(raw);
                return string;
            }
            catch (LargeObjectException e) {
                try {
                    throw new CompileException("rules of " + project + " are too large", e);
                    catch (IOException | RuntimeException e2) {
                        throw new CompileException("Cannot load rules of " + project, e2);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        catch (IOException e) {
            throw new CompileException("Cannot open repository " + project, e);
        }
    }

    private BufferingPrologControl newEmptyMachine(ClassLoader cl) {
        BufferingPrologControl ctl = new BufferingPrologControl();
        ctl.setMaxDatabaseSize(this.maxDbSize);
        ctl.setPrologClassLoader(new PrologClassLoader(new PredicateClassLoader(this.predicateProviders, cl)));
        ctl.setEnabled(EnumSet.allOf(Prolog.Feature.class), false);
        ArrayList<String> packages = new ArrayList<String>();
        packages.addAll(PACKAGE_LIST);
        for (PredicateProvider predicateProvider : this.predicateProviders) {
            packages.addAll(predicateProvider.getPackages());
        }
        ctl.initialize(packages.toArray(new String[packages.size()]));
        return ctl;
    }

    private static URL toURL(Path jarPath) throws CompileException {
        try {
            return jarPath.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new CompileException("Cannot create URL for " + jarPath, e);
        }
    }

    private static final class MachineRef
    extends WeakReference<PrologMachineCopy> {
        final ObjectId key;

        MachineRef(ObjectId key, PrologMachineCopy pcm, ReferenceQueue<PrologMachineCopy> queue) {
            super(pcm, queue);
            this.key = key;
        }
    }
}

