/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Streams;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.client.Side;
import com.google.gerrit.extensions.common.CommentInfo;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.GerritServerId;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.update.BatchUpdateReviewDb;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

@Singleton
public class CommentsUtil {
    public static final Ordering<Comment> COMMENT_ORDER = new Ordering<Comment>(){

        @Override
        public int compare(Comment c1, Comment c2) {
            return ComparisonChain.start().compare((Comparable<?>)((Object)c1.key.filename), (Comparable<?>)((Object)c2.key.filename)).compare(c1.key.patchSetId, c2.key.patchSetId).compare(c1.side, c2.side).compare(c1.lineNbr, c2.lineNbr).compare(c1.writtenOn, c2.writtenOn).result();
        }
    };
    public static final Ordering<CommentInfo> COMMENT_INFO_ORDER = new Ordering<CommentInfo>(){

        @Override
        public int compare(CommentInfo a, CommentInfo b) {
            return ComparisonChain.start().compare(a.path, b.path, NULLS_FIRST).compare(a.patchSet, b.patchSet, NULLS_FIRST).compare(this.side(a), this.side(b)).compare(a.line, b.line, NULLS_FIRST).compare(a.inReplyTo, b.inReplyTo, NULLS_FIRST).compare((Comparable<?>)((Object)a.message), (Comparable<?>)((Object)b.message)).compare((Comparable<?>)((Object)a.id), (Comparable<?>)((Object)b.id)).result();
        }

        private int side(CommentInfo c) {
            return MoreObjects.firstNonNull(c.side, Side.REVISION).ordinal();
        }
    };
    private static final Ordering<Comparable<?>> NULLS_FIRST = Ordering.natural().nullsFirst();
    private final GitRepositoryManager repoManager;
    private final AllUsersName allUsers;
    private final NotesMigration migration;
    private final PatchListCache patchListCache;
    private final PatchSetUtil psUtil;
    private final String serverId;

    public static PatchSet.Id getCommentPsId(Change.Id changeId, Comment comment) {
        return new PatchSet.Id(changeId, comment.key.patchSetId);
    }

    public static String extractMessageId(@Nullable String tag) {
        if (tag == null || !tag.startsWith("mailMessageId=")) {
            return null;
        }
        return tag.substring("mailMessageId=".length());
    }

    @Inject
    CommentsUtil(GitRepositoryManager repoManager, AllUsersName allUsers, NotesMigration migration, PatchListCache patchListCache, PatchSetUtil psUtil, @GerritServerId String serverId) {
        this.repoManager = repoManager;
        this.allUsers = allUsers;
        this.migration = migration;
        this.patchListCache = patchListCache;
        this.psUtil = psUtil;
        this.serverId = serverId;
    }

    public Comment newComment(ChangeContext ctx, String path, PatchSet.Id psId, short side, String message, @Nullable Boolean unresolved, @Nullable String parentUuid) throws OrmException, UnprocessableEntityException {
        if (unresolved == null) {
            if (parentUuid == null) {
                unresolved = false;
            } else {
                Comment.Key key = new Comment.Key(parentUuid, path, psId.patchSetId);
                Optional<Comment> parent = this.getPublished(ctx.getDb(), ctx.getNotes(), key);
                if (!parent.isPresent()) {
                    throw new UnprocessableEntityException("Invalid parentUuid supplied for comment");
                }
                unresolved = parent.get().unresolved;
            }
        }
        Comment c = new Comment(new Comment.Key(ChangeUtil.messageUuid(), path, psId.get()), ctx.getUser().getAccountId(), ctx.getWhen(), side, message, this.serverId, unresolved);
        c.parentUuid = parentUuid;
        ctx.getUser().updateRealAccountId(c::setRealAuthor);
        return c;
    }

    public RobotComment newRobotComment(ChangeContext ctx, String path, PatchSet.Id psId, short side, String message, String robotId, String robotRunId) {
        RobotComment c = new RobotComment(new Comment.Key(ChangeUtil.messageUuid(), path, psId.get()), ctx.getUser().getAccountId(), ctx.getWhen(), side, message, this.serverId, robotId, robotRunId);
        ctx.getUser().updateRealAccountId(c::setRealAuthor);
        return c;
    }

    public Optional<Comment> getPublished(ReviewDb db, ChangeNotes notes, Comment.Key key) throws OrmException {
        if (!this.migration.readChanges()) {
            return this.getReviewDb(db, notes, key);
        }
        return this.publishedByChange(db, notes).stream().filter(c -> key.equals(c.key)).findFirst();
    }

    public Optional<Comment> getDraft(ReviewDb db, ChangeNotes notes, IdentifiedUser user, Comment.Key key) throws OrmException {
        if (!this.migration.readChanges()) {
            Optional<Comment> c2 = this.getReviewDb(db, notes, key);
            if (c2.isPresent() && !c2.get().author.getId().equals(user.getAccountId())) {
                throw new OrmException(String.format("Expected draft %s to belong to account %s, but it belongs to %s", key, user.getAccountId(), c2.get().author.getId()));
            }
            return c2;
        }
        return this.draftByChangeAuthor(db, notes, user.getAccountId()).stream().filter(c -> key.equals(c.key)).findFirst();
    }

    private Optional<Comment> getReviewDb(ReviewDb db, ChangeNotes notes, Comment.Key key) throws OrmException {
        return Optional.ofNullable(db.patchComments().get(PatchLineComment.Key.from(notes.getChangeId(), key))).map(plc -> plc.asComment(this.serverId));
    }

    public List<Comment> publishedByChange(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            return CommentsUtil.sort(this.byCommentStatus(db.patchComments().byChange(notes.getChangeId()), PatchLineComment.Status.PUBLISHED));
        }
        notes.load();
        return CommentsUtil.sort(Lists.newArrayList(notes.getComments().values()));
    }

    public List<RobotComment> robotCommentsByChange(ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            return ImmutableList.of();
        }
        notes.load();
        return CommentsUtil.sort(Lists.newArrayList(notes.getRobotComments().values()));
    }

    public List<Comment> draftByChange(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            return CommentsUtil.sort(this.byCommentStatus(db.patchComments().byChange(notes.getChangeId()), PatchLineComment.Status.DRAFT));
        }
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (Ref ref : this.getDraftRefs(notes.getChangeId())) {
            Account.Id account = Account.Id.fromRefSuffix(ref.getName());
            if (account == null) continue;
            comments.addAll(this.draftByChangeAuthor(db, notes, account));
        }
        return CommentsUtil.sort(comments);
    }

    private List<Comment> byCommentStatus(ResultSet<PatchLineComment> comments, PatchLineComment.Status status) {
        return CommentsUtil.toComments(this.serverId, Lists.newArrayList(Iterables.filter(comments, c -> c.getStatus() == status)));
    }

    public List<Comment> byPatchSet(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readChanges()) {
            return CommentsUtil.sort(CommentsUtil.toComments(this.serverId, db.patchComments().byPatchSet(psId).toList()));
        }
        ArrayList<Comment> comments = new ArrayList<Comment>();
        comments.addAll(this.publishedByPatchSet(db, notes, psId));
        for (Ref ref : this.getDraftRefs(notes.getChangeId())) {
            Account.Id account = Account.Id.fromRefSuffix(ref.getName());
            if (account == null) continue;
            comments.addAll(this.draftByPatchSetAuthor(db, psId, account, notes));
        }
        return CommentsUtil.sort(comments);
    }

    public List<Comment> publishedByChangeFile(ReviewDb db, ChangeNotes notes, Change.Id changeId, String file) throws OrmException {
        if (!this.migration.readChanges()) {
            return CommentsUtil.sort(CommentsUtil.toComments(this.serverId, db.patchComments().publishedByChangeFile(changeId, file).toList()));
        }
        return CommentsUtil.commentsOnFile(((ChangeNotes)notes.load()).getComments().values(), file);
    }

    public List<Comment> publishedByPatchSet(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readChanges()) {
            return this.removeCommentsOnAncestorOfCommitMessage(CommentsUtil.sort(CommentsUtil.toComments(this.serverId, db.patchComments().publishedByPatchSet(psId).toList())));
        }
        return this.removeCommentsOnAncestorOfCommitMessage(CommentsUtil.commentsOnPatchSet(((ChangeNotes)notes.load()).getComments().values(), psId));
    }

    public List<RobotComment> robotCommentsByPatchSet(ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readChanges()) {
            return ImmutableList.of();
        }
        return CommentsUtil.commentsOnPatchSet(((ChangeNotes)notes.load()).getRobotComments().values(), psId);
    }

    private List<Comment> removeCommentsOnAncestorOfCommitMessage(List<Comment> list) {
        return list.stream().filter(c -> c.side != 0 || !"/COMMIT_MSG".equals(c.key.filename)).collect(Collectors.toList());
    }

    public List<Comment> draftByPatchSetAuthor(ReviewDb db, PatchSet.Id psId, Account.Id author, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            return CommentsUtil.sort(CommentsUtil.toComments(this.serverId, db.patchComments().draftByPatchSetAuthor(psId, author).toList()));
        }
        return CommentsUtil.commentsOnPatchSet(((ChangeNotes)notes.load()).getDraftComments(author).values(), psId);
    }

    public List<Comment> draftByChangeFileAuthor(ReviewDb db, ChangeNotes notes, String file, Account.Id author) throws OrmException {
        if (!this.migration.readChanges()) {
            return CommentsUtil.sort(CommentsUtil.toComments(this.serverId, db.patchComments().draftByChangeFileAuthor(notes.getChangeId(), file, author).toList()));
        }
        return CommentsUtil.commentsOnFile(((ChangeNotes)notes.load()).getDraftComments(author).values(), file);
    }

    public List<Comment> draftByChangeAuthor(ReviewDb db, ChangeNotes notes, Account.Id author) throws OrmException {
        if (!this.migration.readChanges()) {
            return Streams.stream(db.patchComments().draftByAuthor(author)).filter(c -> c.getPatchSetId().getParentKey().equals(notes.getChangeId())).map(plc -> plc.asComment(this.serverId)).sorted(COMMENT_ORDER).collect(Collectors.toList());
        }
        ArrayList comments = new ArrayList();
        comments.addAll(notes.getDraftComments(author).values());
        return CommentsUtil.sort(comments);
    }

    @Deprecated
    public List<Change.Id> changesWithDraftsByAuthor(ReviewDb db, Account.Id author) throws OrmException {
        if (!this.migration.readChanges()) {
            return FluentIterable.from(db.patchComments().draftByAuthor(author)).transform(plc -> plc.getPatchSetId().getParentKey()).toList();
        }
        ArrayList<Change.Id> changes = new ArrayList<Change.Id>();
        try (Repository repo = this.repoManager.openRepository(this.allUsers);){
            for (String refName : repo.getRefDatabase().getRefs("refs/draft-comments/").keySet()) {
                Account.Id accountId = Account.Id.fromRefSuffix(refName);
                Change.Id changeId = Change.Id.fromRefPart(refName);
                if (accountId == null || changeId == null) continue;
                changes.add(changeId);
            }
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
        return changes;
    }

    public void putComments(ReviewDb db, ChangeUpdate update, PatchLineComment.Status status, Iterable<Comment> comments) throws OrmException {
        for (Comment c : comments) {
            update.putComment(status, c);
        }
        db.patchComments().upsert(CommentsUtil.toPatchLineComments(update.getId(), status, comments));
    }

    public void putRobotComments(ChangeUpdate update, Iterable<RobotComment> comments) {
        for (RobotComment c : comments) {
            update.putRobotComment(c);
        }
    }

    public void deleteComments(ReviewDb db, ChangeUpdate update, Iterable<Comment> comments) throws OrmException {
        for (Comment c : comments) {
            update.deleteComment(c);
        }
        db.patchComments().delete(CommentsUtil.toPatchLineComments(update.getId(), PatchLineComment.Status.DRAFT, comments));
    }

    public void deleteCommentByRewritingHistory(ReviewDb db, ChangeUpdate update, Comment.Key commentKey, PatchSet.Id psId, String newMessage) throws OrmException {
        if (NoteDbChangeState.PrimaryStorage.of(update.getChange()).equals((Object)NoteDbChangeState.PrimaryStorage.REVIEW_DB)) {
            PatchLineComment patchLineComment;
            PatchLineComment.Key key = new PatchLineComment.Key(new Patch.Key(psId, commentKey.filename), commentKey.uuid);
            if (db instanceof BatchUpdateReviewDb) {
                db = ((BatchUpdateReviewDb)db).unsafeGetDelegate();
            }
            if (!(patchLineComment = (db = ReviewDbUtil.unwrapDb(db)).patchComments().get(key)).getStatus().equals((Object)PatchLineComment.Status.PUBLISHED)) {
                throw new OrmException(String.format("comment %s is not published", key));
            }
            patchLineComment.setMessage(newMessage);
            db.patchComments().upsert(Collections.singleton(patchLineComment));
        }
        update.deleteCommentByRewritingHistory(commentKey.uuid, newMessage);
    }

    public void deleteAllDraftsFromAllUsers(Change.Id changeId) throws IOException {
        try (Repository repo = this.repoManager.openRepository(this.allUsers);
             RevWalk rw = new RevWalk(repo);){
            BatchRefUpdate bru = repo.getRefDatabase().newBatchUpdate();
            for (Ref ref : this.getDraftRefs(repo, changeId)) {
                bru.addCommand(new ReceiveCommand(ref.getObjectId(), ObjectId.zeroId(), ref.getName()));
            }
            bru.setRefLogMessage("Delete drafts from NoteDb", false);
            bru.execute(rw, NullProgressMonitor.INSTANCE);
            for (ReceiveCommand cmd : bru.getCommands()) {
                if (cmd.getResult() == ReceiveCommand.Result.OK) continue;
                throw new IOException(String.format("Failed to delete draft comment ref %s at %s: %s (%s)", new Object[]{cmd.getRefName(), cmd.getOldId(), cmd.getResult(), cmd.getMessage()}));
            }
        }
    }

    private static List<Comment> commentsOnFile(Collection<Comment> allComments, String file) {
        ArrayList<Comment> result = new ArrayList<Comment>(allComments.size());
        for (Comment c : allComments) {
            String currentFilename = c.key.filename;
            if (!currentFilename.equals(file)) continue;
            result.add(c);
        }
        return CommentsUtil.sort(result);
    }

    private static <T extends Comment> List<T> commentsOnPatchSet(Collection<T> allComments, PatchSet.Id psId) {
        ArrayList<Comment> result = new ArrayList<Comment>(allComments.size());
        for (Comment c : allComments) {
            if (c.key.patchSetId != psId.get()) continue;
            result.add(c);
        }
        return CommentsUtil.sort(result);
    }

    public static void setCommentRevId(Comment c, PatchListCache cache, Change change, PatchSet ps) throws PatchListNotAvailableException {
        Preconditions.checkArgument(c.key.patchSetId == ps.getId().get(), "cannot set RevId for patch set %s on comment %s", (Object)ps.getId(), (Object)c);
        if (c.revId == null) {
            c.revId = Side.fromShort(c.side) == Side.PARENT ? (c.side < 0 ? ObjectId.toString(cache.getOldId(change, ps, Integer.valueOf(-c.side))) : ObjectId.toString(cache.getOldId(change, ps, null))) : ps.getRevision().get();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Ref> getDraftRefs(Change.Id changeId) throws OrmException {
        try (Repository repo = this.repoManager.openRepository(this.allUsers);){
            Collection<Ref> collection = this.getDraftRefs(repo, changeId);
            return collection;
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    private Collection<Ref> getDraftRefs(Repository repo, Change.Id changeId) throws IOException {
        return repo.getRefDatabase().getRefs(RefNames.refsDraftCommentsPrefix(changeId)).values();
    }

    private static <T extends Comment> List<T> sort(List<T> comments) {
        Collections.sort(comments, COMMENT_ORDER);
        return comments;
    }

    public static Iterable<PatchLineComment> toPatchLineComments(Change.Id changeId, PatchLineComment.Status status, Iterable<Comment> comments) {
        return FluentIterable.from(comments).transform(c -> PatchLineComment.from(changeId, status, c));
    }

    public static List<Comment> toComments(String serverId, Iterable<PatchLineComment> comments) {
        return COMMENT_ORDER.sortedCopy(FluentIterable.from(comments).transform(plc -> plc.asComment(serverId)));
    }

    public void publish(ChangeContext ctx, PatchSet.Id psId, Collection<Comment> drafts, @Nullable String tag) throws OrmException {
        ChangeNotes notes = ctx.getNotes();
        Preconditions.checkArgument(notes != null);
        if (drafts.isEmpty()) {
            return;
        }
        ImmutableMap<PatchSet.Id, PatchSet> patchSets = this.psUtil.getAsMap(ctx.getDb(), notes, drafts.stream().map(d -> CommentsUtil.psId(notes, d)).collect(Collectors.toSet()));
        for (Comment d2 : drafts) {
            PatchSet ps = (PatchSet)patchSets.get(CommentsUtil.psId(notes, d2));
            if (ps == null) {
                throw new OrmException("patch set " + ps + " not found");
            }
            d2.writtenOn = ctx.getWhen();
            d2.tag = tag;
            ctx.getUser().updateRealAccountId(d2::setRealAuthor);
            try {
                CommentsUtil.setCommentRevId(d2, this.patchListCache, notes.getChange(), ps);
            }
            catch (PatchListNotAvailableException e) {
                throw new OrmException(e);
            }
        }
        this.putComments(ctx.getDb(), ctx.getUpdate(psId), PatchLineComment.Status.PUBLISHED, drafts);
    }

    private static PatchSet.Id psId(ChangeNotes notes, Comment c) {
        return new PatchSet.Id(notes.getChangeId(), c.key.patchSetId);
    }
}

