/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.EditPreferencesInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetEditPreferences;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class SetEditPreferences
implements RestModifyView<AccountResource, EditPreferencesInfo> {
    private final Provider<CurrentUser> self;
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final PermissionBackend permissionBackend;
    private final GitRepositoryManager gitMgr;
    private final AllUsersName allUsersName;

    @Inject
    SetEditPreferences(Provider<CurrentUser> self, Provider<MetaDataUpdate.User> metaDataUpdateFactory, PermissionBackend permissionBackend, GitRepositoryManager gitMgr, AllUsersName allUsersName) {
        this.self = self;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.permissionBackend = permissionBackend;
        this.gitMgr = gitMgr;
        this.allUsersName = allUsersName;
    }

    public EditPreferencesInfo apply(AccountResource rsrc, EditPreferencesInfo in) throws AuthException, BadRequestException, RepositoryNotFoundException, IOException, ConfigInvalidException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.MODIFY_ACCOUNT);
        }
        if (in == null) {
            throw new BadRequestException("input must be provided");
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        EditPreferencesInfo out = new EditPreferencesInfo();
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName);){
            VersionedAccountPreferences prefs = VersionedAccountPreferences.forUser(accountId);
            prefs.load(md);
            ConfigUtil.storeSection(prefs.getConfig(), "edit", null, GetEditPreferences.readFromGit(accountId, this.gitMgr, this.allUsersName, in), EditPreferencesInfo.defaults());
            prefs.commit(md);
            out = ConfigUtil.loadSection(prefs.getConfig(), "edit", null, out, EditPreferencesInfo.defaults(), null);
        }
        return out;
    }
}

