/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.PublishChangeEditInput;
import com.google.gerrit.extensions.client.ChangeEditDetailOption;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.api.ApiUtil;
import com.google.gerrit.server.change.ChangeEditResource;
import com.google.gerrit.server.change.ChangeEdits;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.DeleteChangeEdit;
import com.google.gerrit.server.change.PublishChangeEdit;
import com.google.gerrit.server.change.RebaseChangeEdit;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Optional;

public class ChangeEditApiImpl
implements ChangeEditApi {
    private final Provider<ChangeEdits.Detail> editDetailProvider;
    private final ChangeEdits.Post changeEditsPost;
    private final DeleteChangeEdit deleteChangeEdit;
    private final RebaseChangeEdit.Rebase rebaseChangeEdit;
    private final PublishChangeEdit.Publish publishChangeEdit;
    private final Provider<ChangeEdits.Get> changeEditsGetProvider;
    private final ChangeEdits.Put changeEditsPut;
    private final ChangeEdits.DeleteContent changeEditDeleteContent;
    private final Provider<ChangeEdits.GetMessage> getChangeEditCommitMessageProvider;
    private final ChangeEdits.EditMessage modifyChangeEditCommitMessage;
    private final ChangeEdits changeEdits;
    private final ChangeResource changeResource;

    @Inject
    public ChangeEditApiImpl(Provider<ChangeEdits.Detail> editDetailProvider, ChangeEdits.Post changeEditsPost, DeleteChangeEdit deleteChangeEdit, RebaseChangeEdit.Rebase rebaseChangeEdit, PublishChangeEdit.Publish publishChangeEdit, Provider<ChangeEdits.Get> changeEditsGetProvider, ChangeEdits.Put changeEditsPut, ChangeEdits.DeleteContent changeEditDeleteContent, Provider<ChangeEdits.GetMessage> getChangeEditCommitMessageProvider, ChangeEdits.EditMessage modifyChangeEditCommitMessage, ChangeEdits changeEdits, @Assisted ChangeResource changeResource) {
        this.editDetailProvider = editDetailProvider;
        this.changeEditsPost = changeEditsPost;
        this.deleteChangeEdit = deleteChangeEdit;
        this.rebaseChangeEdit = rebaseChangeEdit;
        this.publishChangeEdit = publishChangeEdit;
        this.changeEditsGetProvider = changeEditsGetProvider;
        this.changeEditsPut = changeEditsPut;
        this.changeEditDeleteContent = changeEditDeleteContent;
        this.getChangeEditCommitMessageProvider = getChangeEditCommitMessageProvider;
        this.modifyChangeEditCommitMessage = modifyChangeEditCommitMessage;
        this.changeEdits = changeEdits;
        this.changeResource = changeResource;
    }

    @Override
    public ChangeEditApi.ChangeEditDetailRequest detail() throws RestApiException {
        try {
            return new ChangeEditApi.ChangeEditDetailRequest(){

                @Override
                public Optional<EditInfo> get() throws RestApiException {
                    return ChangeEditApiImpl.this.get(this);
                }
            };
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve change edit", e);
        }
    }

    private Optional<EditInfo> get(ChangeEditApi.ChangeEditDetailRequest r) throws RestApiException {
        try {
            ChangeEdits.Detail editDetail = this.editDetailProvider.get();
            editDetail.setBase(r.getBase());
            editDetail.setList(r.options().contains((Object)ChangeEditDetailOption.LIST_FILES));
            editDetail.setDownloadCommands(r.options().contains((Object)ChangeEditDetailOption.DOWNLOAD_COMMANDS));
            Response<EditInfo> edit = editDetail.apply(this.changeResource);
            return edit.isNone() ? Optional.empty() : Optional.of(edit.value());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve change edit", e);
        }
    }

    @Override
    public Optional<EditInfo> get() throws RestApiException {
        try {
            Response<EditInfo> edit = this.editDetailProvider.get().apply(this.changeResource);
            return edit.isNone() ? Optional.empty() : Optional.of(edit.value());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve change edit", e);
        }
    }

    @Override
    public void create() throws RestApiException {
        try {
            this.changeEditsPost.apply(this.changeResource, null);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot create change edit", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteChangeEdit.apply(this.changeResource, new DeleteChangeEdit.Input());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete change edit", e);
        }
    }

    @Override
    public void rebase() throws RestApiException {
        try {
            this.rebaseChangeEdit.apply(this.changeResource, null);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot rebase change edit", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        this.publish(null);
    }

    @Override
    public void publish(PublishChangeEditInput publishChangeEditInput) throws RestApiException {
        try {
            this.publishChangeEdit.apply(this.changeResource, publishChangeEditInput);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot publish change edit", e);
        }
    }

    @Override
    public Optional<BinaryResult> getFile(String filePath) throws RestApiException {
        try {
            ChangeEditResource changeEditResource = this.getChangeEditResource(filePath);
            Response<BinaryResult> fileResponse = this.changeEditsGetProvider.get().apply(changeEditResource);
            return fileResponse.isNone() ? Optional.empty() : Optional.of(fileResponse.value());
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot retrieve file of change edit", e);
        }
    }

    @Override
    public void renameFile(String oldFilePath, String newFilePath) throws RestApiException {
        try {
            ChangeEdits.Post.Input renameInput = new ChangeEdits.Post.Input();
            renameInput.oldPath = oldFilePath;
            renameInput.newPath = newFilePath;
            this.changeEditsPost.apply(this.changeResource, renameInput);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot rename file of change edit", e);
        }
    }

    @Override
    public void restoreFile(String filePath) throws RestApiException {
        try {
            ChangeEdits.Post.Input restoreInput = new ChangeEdits.Post.Input();
            restoreInput.restorePath = filePath;
            this.changeEditsPost.apply(this.changeResource, restoreInput);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot restore file of change edit", e);
        }
    }

    @Override
    public void modifyFile(String filePath, RawInput newContent) throws RestApiException {
        try {
            this.changeEditsPut.apply(this.changeResource, filePath, newContent);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot modify file of change edit", e);
        }
    }

    @Override
    public void deleteFile(String filePath) throws RestApiException {
        try {
            this.changeEditDeleteContent.apply(this.changeResource, filePath);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot delete file of change edit", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getCommitMessage() throws RestApiException {
        try (BinaryResult binaryResult = this.getChangeEditCommitMessageProvider.get().apply(this.changeResource);){
            String string = binaryResult.asString();
            return string;
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot get commit message of change edit", e);
        }
    }

    @Override
    public void modifyCommitMessage(String newCommitMessage) throws RestApiException {
        ChangeEdits.EditMessage.Input input = new ChangeEdits.EditMessage.Input();
        input.message = newCommitMessage;
        try {
            this.modifyChangeEditCommitMessage.apply(this.changeResource, input);
        }
        catch (Exception e) {
            throw ApiUtil.asRestApiException("Cannot modify commit message of change edit", e);
        }
    }

    private ChangeEditResource getChangeEditResource(String filePath) throws ResourceNotFoundException, AuthException, IOException, OrmException {
        return this.changeEdits.parse(this.changeResource, IdString.fromDecoded(filePath));
    }

    static interface Factory {
        public ChangeEditApiImpl create(ChangeResource var1);
    }
}

