/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.common.MergePatchSetInput;
import com.google.gerrit.extensions.restapi.MergeConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MergeIdenticalTreeException;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.CommitsCollection;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.TimeZone;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.util.ChangeIdUtil;

@Singleton
public class CreateMergePatchSet
extends RetryingRestModifyView<ChangeResource, MergePatchSetInput, Response<ChangeInfo>> {
    private final Provider<ReviewDb> db;
    private final GitRepositoryManager gitManager;
    private final CommitsCollection commits;
    private final TimeZone serverTimeZone;
    private final Provider<CurrentUser> user;
    private final ChangeJson.Factory jsonFactory;
    private final PatchSetUtil psUtil;
    private final MergeUtil.Factory mergeUtilFactory;
    private final PatchSetInserter.Factory patchSetInserterFactory;
    private final ProjectCache projectCache;

    @Inject
    CreateMergePatchSet(Provider<ReviewDb> db, GitRepositoryManager gitManager, CommitsCollection commits, @GerritPersonIdent PersonIdent myIdent, Provider<CurrentUser> user, ChangeJson.Factory json, PatchSetUtil psUtil, MergeUtil.Factory mergeUtilFactory, RetryHelper retryHelper, PatchSetInserter.Factory patchSetInserterFactory, ProjectCache projectCache) {
        super(retryHelper);
        this.db = db;
        this.gitManager = gitManager;
        this.commits = commits;
        this.serverTimeZone = myIdent.getTimeZone();
        this.user = user;
        this.jsonFactory = json;
        this.psUtil = psUtil;
        this.mergeUtilFactory = mergeUtilFactory;
        this.patchSetInserterFactory = patchSetInserterFactory;
        this.projectCache = projectCache;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Response<ChangeInfo> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, MergePatchSetInput in) throws OrmException, IOException, InvalidChangeOperationException, RestApiException, UpdateException, PermissionBackendException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RevCommit createMergeCommit(MergePatchSetInput in, ProjectState projectState, Branch.NameKey dest, Repository git, ObjectInserter oi, RevWalk rw, RevCommit currentPsCommit, RevCommit sourceCommit, PersonIdent author, ObjectId changeId) throws ResourceNotFoundException, MergeIdenticalTreeException, MergeConflictException, IOException {
        ObjectId parentCommit;
        if (in.inheritParent) {
            parentCommit = currentPsCommit.getParent(0);
        } else {
            Ref destRef = git.getRefDatabase().exactRef(dest.get());
            if (destRef != null) {
                parentCommit = destRef.getObjectId();
            } else {
                throw new ResourceNotFoundException("cannot find destination branch");
            }
        }
        RevCommit mergeTip = rw.parseCommit(parentCommit);
        String commitMsg = Strings.emptyToNull(in.subject) != null ? ChangeIdUtil.insertId(in.subject, changeId) : currentPsCommit.getFullMessage();
        String mergeStrategy = MoreObjects.firstNonNull(Strings.emptyToNull(in.merge.strategy), this.mergeUtilFactory.create(projectState).mergeStrategyName());
        return MergeUtil.createMergeCommit(oi, git.getConfig(), mergeTip, sourceCommit, mergeStrategy, author, commitMsg, rw);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

