/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.EnumSet;
import org.kohsuke.args4j.Option;

public class GetChange
implements RestReadView<ChangeResource> {
    private final ChangeJson.Factory json;
    private final EnumSet<ListChangesOption> options = EnumSet.noneOf(ListChangesOption.class);

    @Option(name="-o", usage="Output options")
    void addOption(ListChangesOption o) {
        this.options.add(o);
    }

    @Option(name="-O", usage="Output option flags, in hex")
    void setOptionFlagsHex(String hex) {
        this.options.addAll(ListChangesOption.fromBits(Integer.parseInt(hex, 16)));
    }

    @Inject
    GetChange(ChangeJson.Factory json) {
        this.json = json;
    }

    public Response<ChangeInfo> apply(ChangeResource rsrc) throws OrmException {
        return Response.withMustRevalidate(this.json.create(this.options).format(rsrc));
    }

    Response<ChangeInfo> apply(RevisionResource rsrc) throws OrmException {
        return Response.withMustRevalidate(this.json.create(this.options).format(rsrc));
    }
}

