/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.change.VoteResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.TreeMap;

@Singleton
public class Votes
implements ChildCollection<ReviewerResource, VoteResource> {
    private final DynamicMap<RestView<VoteResource>> views;
    private final List list;

    @Inject
    Votes(DynamicMap<RestView<VoteResource>> views, List list) {
        this.views = views;
        this.list = list;
    }

    @Override
    public DynamicMap<RestView<VoteResource>> views() {
        return this.views;
    }

    @Override
    public RestView<ReviewerResource> list() throws AuthException {
        return this.list;
    }

    @Override
    public VoteResource parse(ReviewerResource reviewer, IdString id) throws ResourceNotFoundException, OrmException, AuthException, MethodNotAllowedException {
        if (reviewer.getRevisionResource() != null && !reviewer.getRevisionResource().isCurrent()) {
            throw new MethodNotAllowedException("Cannot access on non-current patch set");
        }
        return new VoteResource(reviewer, id.get());
    }

    @Singleton
    public static class List
    implements RestReadView<ReviewerResource> {
        private final Provider<ReviewDb> db;
        private final ApprovalsUtil approvalsUtil;

        @Inject
        List(Provider<ReviewDb> db, ApprovalsUtil approvalsUtil) {
            this.db = db;
            this.approvalsUtil = approvalsUtil;
        }

        public Map<String, Short> apply(ReviewerResource rsrc) throws OrmException, MethodNotAllowedException {
            if (rsrc.getRevisionResource() != null && !rsrc.getRevisionResource().isCurrent()) {
                throw new MethodNotAllowedException("Cannot list votes on non-current patch set");
            }
            TreeMap<String, Short> votes = new TreeMap<String, Short>();
            Iterable<PatchSetApproval> byPatchSetUser = this.approvalsUtil.byPatchSetUser(this.db.get(), rsrc.getChangeResource().getNotes(), rsrc.getChangeResource().getUser(), rsrc.getChange().currentPatchSetId(), rsrc.getReviewerUser().getAccountId(), null, null);
            for (PatchSetApproval psa : byPatchSetUser) {
                votes.put(psa.getLabel(), psa.getValue());
            }
            return votes;
        }
    }
}

