/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ListTasks;
import com.google.gerrit.server.config.TaskResource;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class TasksCollection
implements ChildCollection<ConfigResource, TaskResource> {
    private final DynamicMap<RestView<TaskResource>> views;
    private final ListTasks list;
    private final WorkQueue workQueue;
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;

    @Inject
    TasksCollection(DynamicMap<RestView<TaskResource>> views, ListTasks list, WorkQueue workQueue, Provider<CurrentUser> self, PermissionBackend permissionBackend) {
        this.views = views;
        this.list = list;
        this.workQueue = workQueue;
        this.self = self;
        this.permissionBackend = permissionBackend;
    }

    @Override
    public RestView<ConfigResource> list() {
        return this.list;
    }

    @Override
    public TaskResource parse(ConfigResource parent, IdString id) throws ResourceNotFoundException, AuthException, PermissionBackendException {
        int taskId;
        CurrentUser user = this.self.get();
        if (!user.isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        try {
            taskId = (int)Long.parseLong(id.get(), 16);
        }
        catch (NumberFormatException e) {
            throw new ResourceNotFoundException(id);
        }
        WorkQueue.Task<?> task = this.workQueue.getTask(taskId);
        if (task instanceof WorkQueue.ProjectTask) {
            try {
                this.permissionBackend.user(user).project(((WorkQueue.ProjectTask)task).getProjectNameKey()).check(ProjectPermission.ACCESS);
                return new TaskResource(task);
            }
            catch (AuthException authException) {
                // empty catch block
            }
        }
        if (task != null) {
            try {
                this.permissionBackend.user(user).check(GlobalPermission.VIEW_QUEUE);
                return new TaskResource(task);
            }
            catch (AuthException authException) {
                // empty catch block
            }
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DynamicMap<RestView<TaskResource>> views() {
        return this.views;
    }
}

