/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.fixes;

import com.google.common.base.Preconditions;

class StringModifier {
    private final StringBuilder stringBuilder;
    private int characterShift = 0;
    private int previousEndOffset = Integer.MIN_VALUE;

    StringModifier(String string) {
        Preconditions.checkNotNull(string, "string must not be null");
        this.stringBuilder = new StringBuilder(string);
    }

    public void replace(int startIndex, int endIndex, String replacement) {
        Preconditions.checkNotNull(replacement, "replacement string must not be null");
        if (this.previousEndOffset > startIndex) {
            throw new StringIndexOutOfBoundsException(String.format("Not supported to replace the content starting at index %s after previous replacement which ended at index %s", startIndex, this.previousEndOffset));
        }
        int shiftedStartIndex = startIndex + this.characterShift;
        int shiftedEndIndex = endIndex + this.characterShift;
        if (shiftedEndIndex > this.stringBuilder.length()) {
            throw new StringIndexOutOfBoundsException(String.format("end %s > length %s", shiftedEndIndex, this.stringBuilder.length()));
        }
        this.stringBuilder.replace(shiftedStartIndex, shiftedEndIndex, replacement);
        int replacedContentLength = endIndex - startIndex;
        this.characterShift += replacement.length() - replacedContentLength;
        this.previousEndOffset = endIndex;
    }

    public String getResult() {
        return this.stringBuilder.toString();
    }
}

