/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.collect.Lists;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.TabFile;
import com.google.gerrit.server.git.ValidationError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DestinationList
extends TabFile {
    public static final String DIR_NAME = "destinations";
    private SetMultimap<String, Branch.NameKey> destinations = MultimapBuilder.hashKeys().hashSetValues().build();

    public Set<Branch.NameKey> getDestinations(String label) {
        return this.destinations.get((Object)label);
    }

    public void parseLabel(String label, String text, ValidationError.Sink errors) throws IOException {
        this.destinations.replaceValues((Object)label, DestinationList.toSet(DestinationList.parse(text, DIR_NAME + label, TRIM, null, errors)));
    }

    public String asText(String label) {
        Collection dests = this.destinations.get((Object)label);
        if (dests == null) {
            return null;
        }
        ArrayList<TabFile.Row> rows = Lists.newArrayListWithCapacity(dests.size());
        for (Branch.NameKey dest : DestinationList.sort(dests)) {
            rows.add(new TabFile.Row(dest.get(), dest.getParentKey().get()));
        }
        return DestinationList.asText("Ref", "Project", rows);
    }

    protected static Set<Branch.NameKey> toSet(List<TabFile.Row> destRows) {
        HashSet<Branch.NameKey> dests = Sets.newHashSetWithExpectedSize(destRows.size());
        for (TabFile.Row row : destRows) {
            dests.add(new Branch.NameKey(new Project.NameKey(row.right), row.left));
        }
        return dests;
    }
}

