/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.DefaultQueueOp;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.PersonIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameGroupOp
extends DefaultQueueOp {
    private static final int MAX_TRIES = 10;
    private static final Logger log = LoggerFactory.getLogger(RenameGroupOp.class);
    private final ProjectCache projectCache;
    private final MetaDataUpdate.Server metaDataUpdateFactory;
    private final PersonIdent author;
    private final AccountGroup.UUID uuid;
    private final String oldName;
    private final String newName;
    private final List<Project.NameKey> retryOn;
    private boolean tryingAgain;

    @Inject
    public RenameGroupOp(WorkQueue workQueue, ProjectCache projectCache, MetaDataUpdate.Server metaDataUpdateFactory, @Assisted(value="author") PersonIdent author, @Assisted AccountGroup.UUID uuid, @Assisted(value="oldName") String oldName, @Assisted(value="newName") String newName) {
        super(workQueue);
        this.projectCache = projectCache;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.author = author;
        this.uuid = uuid;
        this.oldName = oldName;
        this.newName = newName;
        this.retryOn = new ArrayList<Project.NameKey>();
    }

    @Override
    public void run() {
        Iterable<Project.NameKey> names = this.tryingAgain ? this.retryOn : this.projectCache.all();
        for (Project.NameKey projectName : names) {
            ProjectConfig config = this.projectCache.get(projectName).getConfig();
            GroupReference ref = config.getGroup(this.uuid);
            if (ref == null || this.newName.equals(ref.getName())) continue;
            try {
                MetaDataUpdate md = this.metaDataUpdateFactory.create(projectName);
                Throwable throwable = null;
                try {
                    this.rename(md);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (md == null) continue;
                    if (throwable != null) {
                        try {
                            md.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    md.close();
                }
            }
            catch (RepositoryNotFoundException noProject) {
            }
            catch (IOException | ConfigInvalidException err) {
                log.error("Cannot rename group " + this.oldName + " in " + projectName, err);
            }
        }
        if (!this.retryOn.isEmpty() && !this.tryingAgain) {
            this.tryingAgain = true;
            ScheduledFuture<?> scheduledFuture = this.start(5L, TimeUnit.MINUTES);
        }
    }

    private void rename(MetaDataUpdate md) throws IOException, ConfigInvalidException {
        boolean success = false;
        for (int attempts = 0; !success && attempts < 10; ++attempts) {
            ProjectConfig config = ProjectConfig.read(md);
            GroupReference ref = config.getGroup(this.uuid);
            if (ref == null || this.newName.equals(ref.getName())) {
                this.projectCache.evict(config.getProject());
                return;
            }
            ref.setName(this.newName);
            md.getCommitBuilder().setAuthor(this.author);
            md.setMessage("Rename group " + this.oldName + " to " + this.newName + "\n");
            try {
                config.commit(md);
                this.projectCache.evict(config.getProject());
                success = true;
                continue;
            }
            catch (IOException e) {
                log.error("Could not commit rename of group " + this.oldName + " to " + this.newName + " in " + md.getProjectName().get(), e);
                try {
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException wakeUp) {
                    // empty catch block
                }
            }
        }
        if (!success) {
            if (this.tryingAgain) {
                log.warn("Could not rename group " + this.oldName + " to " + this.newName + " in " + md.getProjectName().get());
            } else {
                this.retryOn.add(md.getProjectName());
            }
        }
    }

    public String toString() {
        return "Rename Group " + this.oldName;
    }

    public static interface Factory {
        public RenameGroupOp create(@Assisted(value="author") PersonIdent var1, @Assisted AccountGroup.UUID var2, @Assisted(value="oldName") String var3, @Assisted(value="newName") String var4);
    }
}

