/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.receive;

import java.io.IOException;
import java.util.Map;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;

class HookUtil {
    static Map<String, Ref> ensureAllRefsAdvertised(BaseReceivePack rp) throws ServiceMayNotContinueException {
        Map<String, Ref> refs = rp.getAdvertisedRefs();
        if (refs != null) {
            return refs;
        }
        try {
            refs = rp.getRepository().getRefDatabase().getRefs("");
        }
        catch (ServiceMayNotContinueException e) {
            throw e;
        }
        catch (IOException e) {
            ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
            ex.initCause(e);
            throw ex;
        }
        rp.setAdvertisedRefs(refs, rp.getAdvertisedObjects());
        return refs;
    }

    private HookUtil() {
    }
}

