/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.validators;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountConfig;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevWalk;

public class AccountValidator {
    private final Provider<IdentifiedUser> self;
    private final OutgoingEmailValidator emailValidator;

    @Inject
    public AccountValidator(Provider<IdentifiedUser> self, OutgoingEmailValidator emailValidator) {
        this.self = self;
        this.emailValidator = emailValidator;
    }

    public List<String> validate(Account.Id accountId, RevWalk rw, @Nullable ObjectId oldId, ObjectId newId) throws IOException {
        Account newAccount;
        Account oldAccount = null;
        if (oldId != null && !ObjectId.zeroId().equals(oldId)) {
            try {
                oldAccount = this.loadAccount(accountId, rw, oldId);
            }
            catch (ConfigInvalidException configInvalidException) {
                // empty catch block
            }
        }
        try {
            newAccount = this.loadAccount(accountId, rw, newId);
        }
        catch (ConfigInvalidException e) {
            return ImmutableList.of(String.format("commit '%s' has an invalid '%s' file for account '%s': %s", newId.name(), "account.config", accountId.get(), e.getMessage()));
        }
        ArrayList<String> messages = new ArrayList<String>();
        if (accountId.equals(this.self.get().getAccountId()) && !newAccount.isActive()) {
            messages.add("cannot deactivate own account");
        }
        if (!(newAccount.getPreferredEmail() == null || oldAccount != null && newAccount.getPreferredEmail().equals(oldAccount.getPreferredEmail()) || this.emailValidator.isValid(newAccount.getPreferredEmail()))) {
            messages.add(String.format("invalid preferred email '%s' for account '%s'", newAccount.getPreferredEmail(), accountId.get()));
        }
        return ImmutableList.copyOf(messages);
    }

    private Account loadAccount(Account.Id accountId, RevWalk rw, ObjectId commit) throws IOException, ConfigInvalidException {
        rw.reset();
        AccountConfig accountConfig = new AccountConfig(null, accountId);
        accountConfig.load(rw, commit);
        return accountConfig.getAccount();
    }
}

