/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.index.RefState;
import com.google.gerrit.server.index.change.AutoValue_StalenessChecker_RefStatePattern;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.index.change.IndexedChangeQuery;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StalenessChecker {
    private static final Logger log = LoggerFactory.getLogger(StalenessChecker.class);
    public static final ImmutableSet<String> FIELDS = ImmutableSet.of(ChangeField.CHANGE.getName(), ChangeField.REF_STATE.getName(), ChangeField.REF_STATE_PATTERN.getName());
    private final ChangeIndexCollection indexes;
    private final GitRepositoryManager repoManager;
    private final IndexConfig indexConfig;
    private final Provider<ReviewDb> db;

    @Inject
    StalenessChecker(ChangeIndexCollection indexes, GitRepositoryManager repoManager, IndexConfig indexConfig, Provider<ReviewDb> db) {
        this.indexes = indexes;
        this.repoManager = repoManager;
        this.indexConfig = indexConfig;
        this.db = db;
    }

    public boolean isStale(Change.Id id) throws IOException, OrmException {
        ChangeIndex i = (ChangeIndex)this.indexes.getSearchIndex();
        if (i == null) {
            return false;
        }
        if (!i.getSchema().hasField(ChangeField.REF_STATE) || !i.getSchema().hasField(ChangeField.REF_STATE_PATTERN)) {
            return false;
        }
        Optional result = i.get(id, IndexedChangeQuery.createOptions(this.indexConfig, 0, 1, FIELDS));
        if (!result.isPresent()) {
            return true;
        }
        ChangeData cd = (ChangeData)result.get();
        return StalenessChecker.isStale(this.repoManager, id, cd.change(), ChangeNotes.readOneReviewDbChange(this.db.get(), id), this.parseStates(cd), this.parsePatterns(cd));
    }

    public static boolean isStale(GitRepositoryManager repoManager, Change.Id id, Change indexChange, @Nullable Change reviewDbChange, SetMultimap<Project.NameKey, RefState> states, ListMultimap<Project.NameKey, RefStatePattern> patterns) {
        return StalenessChecker.reviewDbChangeIsStale(indexChange, reviewDbChange) || StalenessChecker.refsAreStale(repoManager, id, states, patterns);
    }

    @VisibleForTesting
    static boolean refsAreStale(GitRepositoryManager repoManager, Change.Id id, SetMultimap<Project.NameKey, RefState> states, ListMultimap<Project.NameKey, RefStatePattern> patterns) {
        Sets.SetView<Project.NameKey> projects = Sets.union(states.keySet(), patterns.keySet());
        for (Project.NameKey p : projects) {
            if (!StalenessChecker.refsAreStale(repoManager, id, p, states, patterns)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    static boolean reviewDbChangeIsStale(Change indexChange, @Nullable Change reviewDbChange) {
        Preconditions.checkNotNull(indexChange);
        NoteDbChangeState.PrimaryStorage storageFromIndex = NoteDbChangeState.PrimaryStorage.of(indexChange);
        NoteDbChangeState.PrimaryStorage storageFromReviewDb = NoteDbChangeState.PrimaryStorage.of(reviewDbChange);
        if (reviewDbChange == null) {
            return storageFromIndex == NoteDbChangeState.PrimaryStorage.REVIEW_DB;
        }
        Preconditions.checkArgument(indexChange.getId().equals(reviewDbChange.getId()), "mismatched change ID: %s != %s", (Object)indexChange.getId(), (Object)reviewDbChange.getId());
        if (storageFromIndex != storageFromReviewDb) {
            return true;
        }
        if (storageFromReviewDb != NoteDbChangeState.PrimaryStorage.REVIEW_DB) {
            return false;
        }
        return reviewDbChange.getRowVersion() != indexChange.getRowVersion();
    }

    private SetMultimap<Project.NameKey, RefState> parseStates(ChangeData cd) {
        return StalenessChecker.parseStates(cd.getRefStates());
    }

    public static SetMultimap<Project.NameKey, RefState> parseStates(Iterable<byte[]> states) {
        RefState.check(states != null, null);
        Multimap result = MultimapBuilder.hashKeys().hashSetValues().build();
        for (byte[] b : states) {
            RefState.check(b != null, null);
            String s = new String(b, StandardCharsets.UTF_8);
            List<String> parts = Splitter.on(':').splitToList(s);
            RefState.check(parts.size() == 3 && !parts.get(0).isEmpty() && !parts.get(1).isEmpty(), s);
            result.put(new Project.NameKey(parts.get(0)), RefState.create(parts.get(1), parts.get(2)));
        }
        return result;
    }

    private ListMultimap<Project.NameKey, RefStatePattern> parsePatterns(ChangeData cd) {
        return StalenessChecker.parsePatterns(cd.getRefStatePatterns());
    }

    public static ListMultimap<Project.NameKey, RefStatePattern> parsePatterns(Iterable<byte[]> patterns) {
        RefStatePattern.check(patterns != null, null);
        Multimap result = MultimapBuilder.hashKeys().arrayListValues().build();
        for (byte[] b : patterns) {
            RefStatePattern.check(b != null, null);
            String s = new String(b, StandardCharsets.UTF_8);
            List<String> parts = Splitter.on(':').splitToList(s);
            RefStatePattern.check(parts.size() == 2, s);
            result.put(new Project.NameKey(Url.decode(parts.get(0))), RefStatePattern.create(parts.get(1)));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean refsAreStale(GitRepositoryManager repoManager, Change.Id id, Project.NameKey project, SetMultimap<Project.NameKey, RefState> allStates, ListMultimap<Project.NameKey, RefStatePattern> allPatterns) {
        try (Repository repo = repoManager.openRepository(project);){
            Collection states = allStates.get((Object)project);
            for (RefState state : states) {
                if (state.match(repo)) continue;
                boolean bl = true;
                return bl;
            }
            for (RefStatePattern pattern : allPatterns.get((Object)project)) {
                if (pattern.match(repo, (Set)states)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.warn("error checking staleness of {} in {}", id, project, e);
            return true;
        }
    }

    @AutoValue
    public static abstract class RefStatePattern {
        static RefStatePattern create(String pattern) {
            int star = pattern.indexOf(42);
            RefStatePattern.check(star > 0 && pattern.charAt(star - 1) == '/', pattern);
            String prefix = pattern.substring(0, star);
            RefStatePattern.check(Repository.isValidRefName(pattern.replace('*', 'x')), pattern);
            String regex = Streams.stream(Splitter.on('*').split(pattern)).map(Pattern::quote).collect(Collectors.joining(".*", "^", "$"));
            return new AutoValue_StalenessChecker_RefStatePattern(pattern, prefix, Pattern.compile(regex));
        }

        byte[] toByteArray(Project.NameKey project) {
            return (project.toString() + ':' + this.pattern()).getBytes(StandardCharsets.UTF_8);
        }

        private static void check(boolean condition, String str) {
            Preconditions.checkArgument(condition, "invalid RefStatePattern: %s", (Object)str);
        }

        abstract String pattern();

        abstract String prefix();

        abstract Pattern regex();

        boolean match(String refName) {
            return this.regex().matcher(refName).find();
        }

        private boolean match(Repository repo, Set<RefState> expected) throws IOException {
            for (Ref r : repo.getRefDatabase().getRefs(this.prefix()).values()) {
                if (!this.match(r.getName()) || expected.contains(RefState.of(r))) continue;
                return false;
            }
            return true;
        }
    }
}

