/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.mail.MailFilter;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ListMailFilter
implements MailFilter {
    private static final Logger log = LoggerFactory.getLogger(ListMailFilter.class);
    private final ListFilterMode mode;
    private final Pattern mailPattern;

    @Inject
    ListMailFilter(@GerritServerConfig Config cfg) {
        this.mode = cfg.getEnum("receiveemail", "filter", "mode", ListFilterMode.OFF);
        String[] addresses = cfg.getStringList("receiveemail", "filter", "patterns");
        String concat = Arrays.asList(addresses).stream().collect(Collectors.joining("|"));
        this.mailPattern = Pattern.compile(concat);
    }

    @Override
    public boolean shouldProcessMessage(MailMessage message) {
        if (this.mode == ListFilterMode.OFF) {
            return true;
        }
        boolean match = this.mailPattern.matcher(message.from().email).find();
        if (this.mode == ListFilterMode.WHITELIST && !match || this.mode == ListFilterMode.BLACKLIST && match) {
            log.info("Mail message from " + message.from() + " rejected by list filter");
            return false;
        }
        return true;
    }

    public static enum ListFilterMode {
        OFF,
        WHITELIST,
        BLACKLIST;

    }
}

