/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.send;

import com.google.common.base.Joiner;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.reviewdb.client.AccountSshKey;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.mail.Address;
import com.google.gerrit.server.mail.send.EmailArguments;
import com.google.gerrit.server.mail.send.OutgoingEmail;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import java.util.List;

public class DeleteKeySender
extends OutgoingEmail {
    private final IdentifiedUser user;
    private final AccountSshKey sshKey;
    private final List<String> gpgKeyFingerprints;

    @AssistedInject
    public DeleteKeySender(EmailArguments ea, @Assisted IdentifiedUser user, @Assisted AccountSshKey sshKey) {
        super(ea, "deletekey");
        this.user = user;
        this.gpgKeyFingerprints = Collections.emptyList();
        this.sshKey = sshKey;
    }

    @AssistedInject
    public DeleteKeySender(EmailArguments ea, @Assisted IdentifiedUser user, @Assisted List<String> gpgKeyFingerprints) {
        super(ea, "deletekey");
        this.user = user;
        this.gpgKeyFingerprints = gpgKeyFingerprints;
        this.sshKey = null;
    }

    @Override
    protected void init() throws EmailException {
        super.init();
        this.setHeader("Subject", String.format("[Gerrit Code Review] %s Keys Deleted", this.getKeyType()));
        this.add(RecipientType.TO, new Address(this.getEmail()));
    }

    @Override
    protected boolean shouldSendMessage() {
        return true;
    }

    @Override
    protected void format() throws EmailException {
        this.appendText(this.textTemplate("DeleteKey"));
        if (this.useHtml()) {
            this.appendHtml(this.soyHtmlTemplate("DeleteKeyHtml"));
        }
    }

    public String getEmail() {
        return this.user.getAccount().getPreferredEmail();
    }

    public String getUserNameEmail() {
        return this.getUserNameEmailFor(this.user.getAccountId());
    }

    public String getKeyType() {
        if (this.sshKey != null) {
            return "SSH";
        }
        if (this.gpgKeyFingerprints != null) {
            return "GPG";
        }
        throw new IllegalStateException("key type is not SSH or GPG");
    }

    public String getSshKey() {
        return this.sshKey != null ? this.sshKey.getSshPublicKey() + "\n" : null;
    }

    public String getGpgKeyFingerprints() {
        if (!this.gpgKeyFingerprints.isEmpty()) {
            return Joiner.on("\n").join(this.gpgKeyFingerprints);
        }
        return null;
    }

    @Override
    protected void setupSoyContext() {
        super.setupSoyContext();
        this.soyContextEmailData.put("email", this.getEmail());
        this.soyContextEmailData.put("gpgKeyFingerprints", this.getGpgKeyFingerprints());
        this.soyContextEmailData.put("keyType", this.getKeyType());
        this.soyContextEmailData.put("sshKey", this.getSshKey());
        this.soyContextEmailData.put("userNameEmail", this.getUserNameEmail());
    }

    @Override
    protected boolean supportsHtml() {
        return true;
    }

    public static interface Factory {
        public DeleteKeySender create(IdentifiedUser var1, AccountSshKey var2);

        public DeleteKeySender create(IdentifiedUser var1, List<String> var2);
    }
}

