/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.server.git.InMemoryInserter;
import com.google.gerrit.server.git.InsertedObject;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.FooterKey;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class ChangeNotesCommit
extends RevCommit {
    private ListMultimap<String, String> footerLines;

    public static ChangeNotesRevWalk newRevWalk(Repository repo) {
        return new ChangeNotesRevWalk(repo);
    }

    public static ChangeNotesRevWalk newStagedRevWalk(Repository repo, Iterable<InsertedObject> stagedObjs) {
        final InMemoryInserter ins = new InMemoryInserter(repo);
        for (InsertedObject obj : stagedObjs) {
            ins.insert(obj);
        }
        return new ChangeNotesRevWalk(ins.newReader()){

            @Override
            public void close() {
                ins.close();
                super.close();
            }
        };
    }

    public ChangeNotesCommit(AnyObjectId id) {
        super(id);
    }

    public List<String> getFooterLineValues(FooterKey key) {
        if (this.footerLines == null) {
            List<FooterLine> src = this.getFooterLines();
            this.footerLines = MultimapBuilder.hashKeys(src.size()).arrayListValues(1).build();
            for (FooterLine fl : src) {
                this.footerLines.put(fl.getKey().toLowerCase(), fl.getValue());
            }
        }
        return this.footerLines.get((Object)key.getName().toLowerCase());
    }

    public static class ChangeNotesRevWalk
    extends RevWalk {
        private ChangeNotesRevWalk(Repository repo) {
            super(repo);
        }

        private ChangeNotesRevWalk(ObjectReader reader) {
            super(reader);
        }

        @Override
        protected ChangeNotesCommit createCommit(AnyObjectId id) {
            return new ChangeNotesCommit(id);
        }

        @Override
        public ChangeNotesCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return (ChangeNotesCommit)super.next();
        }

        @Override
        public void markStart(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            Preconditions.checkArgument(c instanceof ChangeNotesCommit);
            super.markStart(c);
        }

        @Override
        public void markUninteresting(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            Preconditions.checkArgument(c instanceof ChangeNotesCommit);
            super.markUninteresting(c);
        }

        @Override
        public ChangeNotesCommit lookupCommit(AnyObjectId id) {
            return (ChangeNotesCommit)super.lookupCommit(id);
        }

        @Override
        public ChangeNotesCommit parseCommit(AnyObjectId id) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return (ChangeNotesCommit)super.parseCommit(id);
        }
    }
}

