/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GarbageCollectionResult;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GarbageCollection;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LocalDiskRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Consumer;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GcAllUsers {
    private static final Logger log = LoggerFactory.getLogger(GcAllUsers.class);
    private final AllUsersName allUsers;
    private final GarbageCollection.Factory gcFactory;
    private final GitRepositoryManager repoManager;

    @Inject
    GcAllUsers(AllUsersName allUsers, GarbageCollection.Factory gcFactory, GitRepositoryManager repoManager) {
        this.allUsers = allUsers;
        this.gcFactory = gcFactory;
        this.repoManager = repoManager;
    }

    public void runWithLogger() {
        this.run(s -> log.info((String)s), null);
    }

    public void run(PrintWriter writer) {
        this.run(Preconditions.checkNotNull(writer)::println, writer);
    }

    private void run(Consumer<String> logOneLine, @Nullable PrintWriter progressWriter) {
        GarbageCollectionResult result;
        if (!(this.repoManager instanceof LocalDiskRepositoryManager)) {
            logOneLine.accept("Skipping GC of " + this.allUsers + "; not a local disk repo");
            return;
        }
        if (!this.enableAutoGc(logOneLine)) {
            logOneLine.accept("Skipping GC of " + this.allUsers + " due to disabling " + "gc" + "." + "auto");
            logOneLine.accept("If loading accounts is slow after the NoteDb migration, run `git gc` on " + this.allUsers + " manually");
            return;
        }
        if (progressWriter == null) {
            logOneLine.accept("collecting garbage for \"" + this.allUsers + "\":\n");
        }
        if (!(result = this.gcFactory.create().run(ImmutableList.of(this.allUsers), progressWriter)).hasErrors()) {
            return;
        }
        block5: for (GarbageCollectionResult.Error e : result.getErrors()) {
            switch (e.getType()) {
                case GC_ALREADY_SCHEDULED: {
                    logOneLine.accept("GC already scheduled for " + e.getProjectName());
                    continue block5;
                }
                case GC_FAILED: {
                    logOneLine.accept("GC failed for " + e.getProjectName());
                    continue block5;
                }
                case REPOSITORY_NOT_FOUND: {
                    logOneLine.accept(e.getProjectName() + " repo not found");
                    continue block5;
                }
            }
            logOneLine.accept("GC failed for " + e.getProjectName() + ": " + (Object)((Object)e.getType()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean enableAutoGc(Consumer<String> logOneLine) {
        try (Repository repo = this.repoManager.openRepository(this.allUsers);){
            boolean bl = repo.getConfig().getInt("gc", "auto", -1) != 0;
            return bl;
        }
        catch (IOException e) {
            logOneLine.accept("Error reading config for " + this.allUsers + ":\n" + Throwables.getStackTraceAsString(e));
            return false;
        }
    }
}

