/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.patch.AutoValue_IntraLineDiffArgs;
import com.google.gerrit.server.patch.Text;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.lib.ObjectId;

@AutoValue
public abstract class IntraLineDiffArgs {
    public static IntraLineDiffArgs create(Text aText, Text bText, List<Edit> edits, Set<Edit> editsDueToRebase, Project.NameKey project, ObjectId commit, String path) {
        return new AutoValue_IntraLineDiffArgs(aText, bText, IntraLineDiffArgs.deepCopyEdits(edits), IntraLineDiffArgs.deepCopyEdits(editsDueToRebase), project, commit, path);
    }

    private static ImmutableList<Edit> deepCopyEdits(List<Edit> edits) {
        return edits.stream().map(IntraLineDiffArgs::copy).collect(ImmutableList.toImmutableList());
    }

    private static ImmutableSet<Edit> deepCopyEdits(Set<Edit> edits) {
        return edits.stream().map(IntraLineDiffArgs::copy).collect(ImmutableSet.toImmutableSet());
    }

    private static Edit copy(Edit edit) {
        return new Edit(edit.getBeginA(), edit.getEndA(), edit.getBeginB(), edit.getEndB());
    }

    public abstract Text aText();

    public abstract Text bText();

    public abstract ImmutableList<Edit> edits();

    public abstract ImmutableSet<Edit> editsDueToRebase();

    public abstract Project.NameKey project();

    public abstract ObjectId commit();

    public abstract String path();
}

