/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.patch;

import com.google.common.annotations.VisibleForTesting;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.ioutil.BasicSerialization;
import com.google.gerrit.server.patch.ComparisonType;
import com.google.gerrit.server.patch.PatchListEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSerialization;

public class PatchList
implements Serializable {
    private static final long serialVersionUID = 31L;
    private static final Comparator<PatchListEntry> PATCH_CMP = new Comparator<PatchListEntry>(){

        @Override
        public int compare(PatchListEntry a, PatchListEntry b) {
            return PatchList.comparePaths(a.getNewName(), b.getNewName());
        }
    };
    @Nullable
    private transient ObjectId oldId;
    private transient ObjectId newId;
    private transient boolean isMerge;
    private transient ComparisonType comparisonType;
    private transient int insertions;
    private transient int deletions;
    private transient PatchListEntry[] patches;

    @VisibleForTesting
    static int comparePaths(String a, String b) {
        int m2;
        int m1;
        int n = Patch.isMagic(a) ? (a.equals("/MERGE_LIST") ? 2 : 1) : (m1 = 3);
        int n2 = Patch.isMagic(b) ? (b.equals("/MERGE_LIST") ? 2 : 1) : (m2 = 3);
        if (m1 != m2) {
            return m1 - m2;
        }
        if (m1 < 3) {
            return 0;
        }
        return a.compareTo(b);
    }

    public PatchList(@Nullable AnyObjectId oldId, AnyObjectId newId, boolean isMerge, ComparisonType comparisonType, PatchListEntry[] patches) {
        int i;
        this.oldId = oldId != null ? oldId.copy() : null;
        this.newId = newId.copy();
        this.isMerge = isMerge;
        this.comparisonType = comparisonType;
        Arrays.sort(patches, 0, patches.length, PATCH_CMP);
        for (i = 0; i < patches.length && Patch.isMagic(patches[i].getNewName()); ++i) {
        }
        while (i < patches.length) {
            this.insertions += patches[i].getInsertions();
            this.deletions += patches[i].getDeletions();
            ++i;
        }
        this.patches = patches;
    }

    @Nullable
    public ObjectId getOldId() {
        return this.oldId;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public List<PatchListEntry> getPatches() {
        return Collections.unmodifiableList(Arrays.asList(this.patches));
    }

    public ComparisonType getComparisonType() {
        return this.comparisonType;
    }

    public int getInsertions() {
        return this.insertions;
    }

    public int getDeletions() {
        return this.deletions;
    }

    public List<Patch> toPatchList(PatchSet.Id setId) {
        ArrayList<Patch> r = new ArrayList<Patch>(this.patches.length);
        for (PatchListEntry e : this.patches) {
            r.add(e.toPatch(setId));
        }
        return r;
    }

    public PatchListEntry get(String fileName) {
        int index = this.search(fileName);
        return 0 <= index ? this.patches[index] : PatchListEntry.empty(fileName);
    }

    private int search(String fileName) {
        PatchListEntry want = PatchListEntry.empty(fileName);
        return Arrays.binarySearch(this.patches, 0, this.patches.length, want, PATCH_CMP);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (DeflaterOutputStream out = new DeflaterOutputStream(buf);){
            ObjectIdSerialization.writeCanBeNull(out, this.oldId);
            ObjectIdSerialization.writeNotNull(out, this.newId);
            BasicSerialization.writeVarInt32(out, this.isMerge ? 1 : 0);
            this.comparisonType.writeTo(out);
            BasicSerialization.writeVarInt32(out, this.insertions);
            BasicSerialization.writeVarInt32(out, this.deletions);
            BasicSerialization.writeVarInt32(out, this.patches.length);
            for (PatchListEntry p : this.patches) {
                p.writeTo(out);
            }
        }
        BasicSerialization.writeBytes(output, buf.toByteArray());
    }

    private void readObject(ObjectInputStream input) throws IOException {
        ByteArrayInputStream buf = new ByteArrayInputStream(BasicSerialization.readBytes(input));
        try (InflaterInputStream in = new InflaterInputStream(buf);){
            this.oldId = ObjectIdSerialization.readCanBeNull(in);
            this.newId = ObjectIdSerialization.readNotNull(in);
            this.isMerge = BasicSerialization.readVarInt32(in) != 0;
            this.comparisonType = ComparisonType.readFrom(in);
            this.insertions = BasicSerialization.readVarInt32(in);
            this.deletions = BasicSerialization.readVarInt32(in);
            int cnt = BasicSerialization.readVarInt32(in);
            PatchListEntry[] all = new PatchListEntry[cnt];
            for (int i = 0; i < all.length; ++i) {
                all[i] = PatchListEntry.readFrom(in);
            }
            this.patches = all;
        }
    }
}

