/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.gerrit.extensions.api.projects.CommentLinkInfo;
import com.google.gerrit.extensions.api.projects.ConfigInfo;
import com.google.gerrit.extensions.api.projects.ProjectConfigEntryType;
import com.google.gerrit.extensions.common.ActionInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class ConfigInfoImpl
extends ConfigInfo {
    public ConfigInfoImpl(boolean serverEnableSignedPush, ProjectControl control, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsName allProjects, UiActions uiActions, DynamicMap<RestView<ProjectResource>> views) {
        ProjectState projectState = control.getProjectState();
        Project p = control.getProject();
        this.description = Strings.emptyToNull(p.getDescription());
        ConfigInfo.InheritedBooleanInfo useContributorAgreements = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo useSignedOffBy = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo useContentMerge = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo requireChangeId = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo createNewChangeForAllNotInTarget = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo enableSignedPush = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo requireSignedPush = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo rejectImplicitMerges = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo privateByDefault = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo workInProgressByDefault = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo enableReviewerByEmail = new ConfigInfo.InheritedBooleanInfo();
        ConfigInfo.InheritedBooleanInfo matchAuthorToCommitterDate = new ConfigInfo.InheritedBooleanInfo();
        useContributorAgreements.value = projectState.isUseContributorAgreements();
        useSignedOffBy.value = projectState.isUseSignedOffBy();
        useContentMerge.value = projectState.isUseContentMerge();
        requireChangeId.value = projectState.isRequireChangeID();
        createNewChangeForAllNotInTarget.value = projectState.isCreateNewChangeForAllNotInTarget();
        useContributorAgreements.configuredValue = p.getUseContributorAgreements();
        useSignedOffBy.configuredValue = p.getUseSignedOffBy();
        useContentMerge.configuredValue = p.getUseContentMerge();
        requireChangeId.configuredValue = p.getRequireChangeID();
        createNewChangeForAllNotInTarget.configuredValue = p.getCreateNewChangeForAllNotInTarget();
        enableSignedPush.configuredValue = p.getEnableSignedPush();
        requireSignedPush.configuredValue = p.getRequireSignedPush();
        rejectImplicitMerges.configuredValue = p.getRejectImplicitMerges();
        privateByDefault.configuredValue = p.getPrivateByDefault();
        workInProgressByDefault.configuredValue = p.getWorkInProgressByDefault();
        enableReviewerByEmail.configuredValue = p.getEnableReviewerByEmail();
        matchAuthorToCommitterDate.configuredValue = p.getMatchAuthorToCommitterDate();
        ProjectState parentState = Iterables.getFirst(projectState.parents(), null);
        if (parentState != null) {
            useContributorAgreements.inheritedValue = parentState.isUseContributorAgreements();
            useSignedOffBy.inheritedValue = parentState.isUseSignedOffBy();
            useContentMerge.inheritedValue = parentState.isUseContentMerge();
            requireChangeId.inheritedValue = parentState.isRequireChangeID();
            createNewChangeForAllNotInTarget.inheritedValue = parentState.isCreateNewChangeForAllNotInTarget();
            enableSignedPush.inheritedValue = projectState.isEnableSignedPush();
            requireSignedPush.inheritedValue = projectState.isRequireSignedPush();
            privateByDefault.inheritedValue = projectState.isPrivateByDefault();
            workInProgressByDefault.inheritedValue = projectState.isWorkInProgressByDefault();
            rejectImplicitMerges.inheritedValue = projectState.isRejectImplicitMerges();
            enableReviewerByEmail.inheritedValue = projectState.isEnableReviewerByEmail();
            matchAuthorToCommitterDate.inheritedValue = projectState.isMatchAuthorToCommitterDate();
        }
        this.useContributorAgreements = useContributorAgreements;
        this.useSignedOffBy = useSignedOffBy;
        this.useContentMerge = useContentMerge;
        this.requireChangeId = requireChangeId;
        this.rejectImplicitMerges = rejectImplicitMerges;
        this.createNewChangeForAllNotInTarget = createNewChangeForAllNotInTarget;
        this.enableReviewerByEmail = enableReviewerByEmail;
        this.matchAuthorToCommitterDate = matchAuthorToCommitterDate;
        if (serverEnableSignedPush) {
            this.enableSignedPush = enableSignedPush;
            this.requireSignedPush = requireSignedPush;
        }
        this.privateByDefault = privateByDefault;
        this.workInProgressByDefault = workInProgressByDefault;
        this.maxObjectSizeLimit = this.getMaxObjectSizeLimit(projectState, p);
        this.submitType = p.getSubmitType();
        this.state = p.getState() != com.google.gerrit.extensions.client.ProjectState.ACTIVE ? p.getState() : null;
        this.commentlinks = new LinkedHashMap();
        for (CommentLinkInfo cl : projectState.getCommentLinks()) {
            this.commentlinks.put(cl.name, cl);
        }
        this.pluginConfig = this.getPluginConfig(control.getProjectState(), pluginConfigEntries, cfgFactory, allProjects);
        this.actions = new TreeMap();
        for (UiAction.Description d : uiActions.from(views, new ProjectResource(control))) {
            this.actions.put(d.getId(), new ActionInfo(d));
        }
        this.theme = projectState.getTheme();
        this.extensionPanelNames = projectState.getConfig().getExtensionPanelSections();
    }

    private ConfigInfo.MaxObjectSizeLimitInfo getMaxObjectSizeLimit(ProjectState projectState, Project p) {
        ConfigInfo.MaxObjectSizeLimitInfo info = new ConfigInfo.MaxObjectSizeLimitInfo();
        ProjectState.EffectiveMaxObjectSizeLimit limit = projectState.getEffectiveMaxObjectSizeLimit();
        long value = limit.value;
        info.value = value == 0L ? null : String.valueOf(value);
        info.configuredValue = p.getMaxObjectSizeLimit();
        info.summary = limit.summary;
        return info;
    }

    private Map<String, Map<String, ConfigInfo.ConfigParameterInfo>> getPluginConfig(ProjectState project, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsName allProjects) {
        TreeMap<String, Map<String, ConfigInfo.ConfigParameterInfo>> pluginConfig = new TreeMap<String, Map<String, ConfigInfo.ConfigParameterInfo>>();
        for (DynamicMap.Entry<ProjectConfigEntry> entry : pluginConfigEntries) {
            ProjectConfigEntry configEntry = entry.getProvider().get();
            PluginConfig cfg = cfgFactory.getFromProjectConfig(project, entry.getPluginName());
            String configuredValue = cfg.getString(entry.getExportName());
            ConfigInfo.ConfigParameterInfo p = new ConfigInfo.ConfigParameterInfo();
            p.displayName = configEntry.getDisplayName();
            p.description = configEntry.getDescription();
            p.warning = configEntry.getWarning(project);
            p.type = configEntry.getType();
            p.permittedValues = configEntry.getPermittedValues();
            Boolean bl = p.editable = configEntry.isEditable(project) ? Boolean.valueOf(true) : null;
            if (configEntry.isInheritable() && !allProjects.equals(project.getNameKey())) {
                PluginConfig cfgWithInheritance = cfgFactory.getFromProjectConfigWithInheritance(project, entry.getPluginName());
                p.inheritable = true;
                p.value = configEntry.onRead(project, cfgWithInheritance.getString(entry.getExportName(), configEntry.getDefaultValue()));
                p.configuredValue = configuredValue;
                p.inheritedValue = this.getInheritedValue(project, cfgFactory, entry);
            } else if (configEntry.getType() == ProjectConfigEntryType.ARRAY) {
                p.values = configEntry.onRead(project, Arrays.asList(cfg.getStringList(entry.getExportName())));
            } else {
                p.value = configEntry.onRead(project, configuredValue != null ? configuredValue : configEntry.getDefaultValue());
            }
            Map<String, ConfigInfo.ConfigParameterInfo> pc = pluginConfig.get(entry.getPluginName());
            if (pc == null) {
                pc = new TreeMap<String, ConfigInfo.ConfigParameterInfo>();
                pluginConfig.put(entry.getPluginName(), pc);
            }
            pc.put(entry.getExportName(), p);
        }
        return !pluginConfig.isEmpty() ? pluginConfig : null;
    }

    private String getInheritedValue(ProjectState project, PluginConfigFactory cfgFactory, DynamicMap.Entry<ProjectConfigEntry> e) {
        ProjectConfigEntry configEntry = e.getProvider().get();
        ProjectState parent = Iterables.getFirst(project.parents(), null);
        String inheritedValue = configEntry.getDefaultValue();
        if (parent != null) {
            PluginConfig parentCfgWithInheritance = cfgFactory.getFromProjectConfigWithInheritance(parent, e.getPluginName());
            inheritedValue = parentCfgWithInheritance.getString(e.getExportName(), configEntry.getDefaultValue());
        }
        return inheritedValue;
    }
}

