/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.projects.ConfigInfo;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.EnableSignedPush;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfigFactory;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.extensions.webui.UiActions;
import com.google.gerrit.server.project.ConfigInfoImpl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class GetConfig
implements RestReadView<ProjectResource> {
    private final boolean serverEnableSignedPush;
    private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;
    private final PluginConfigFactory cfgFactory;
    private final AllProjectsName allProjects;
    private final UiActions uiActions;
    private final DynamicMap<RestView<ProjectResource>> views;

    @Inject
    public GetConfig(@EnableSignedPush boolean serverEnableSignedPush, DynamicMap<ProjectConfigEntry> pluginConfigEntries, PluginConfigFactory cfgFactory, AllProjectsName allProjects, UiActions uiActions, DynamicMap<RestView<ProjectResource>> views) {
        this.serverEnableSignedPush = serverEnableSignedPush;
        this.pluginConfigEntries = pluginConfigEntries;
        this.allProjects = allProjects;
        this.cfgFactory = cfgFactory;
        this.uiActions = uiActions;
        this.views = views;
    }

    public ConfigInfo apply(ProjectResource resource) {
        return new ConfigInfoImpl(this.serverEnableSignedPush, resource.getControl(), this.pluginConfigEntries, this.cfgFactory, this.allProjects, this.uiActions, this.views);
    }
}

