/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectCacheClock;
import com.google.gerrit.server.project.ProjectCacheWarmer;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProjectCacheImpl
implements ProjectCache {
    private static final Logger log = LoggerFactory.getLogger(ProjectCacheImpl.class);
    private static final String CACHE_NAME = "projects";
    private static final String CACHE_LIST = "project_list";
    private final AllProjectsName allProjectsName;
    private final AllUsersName allUsersName;
    private final LoadingCache<String, ProjectState> byName;
    private final LoadingCache<ListKey, SortedSet<Project.NameKey>> list;
    private final Lock listLock;
    private final ProjectCacheClock clock;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(ProjectCacheImpl.CACHE_NAME, String.class, ProjectState.class).loader(Loader.class);
                this.cache(ProjectCacheImpl.CACHE_LIST, ListKey.class, new TypeLiteral<SortedSet<Project.NameKey>>(){}).maximumWeight(1L).loader(Lister.class);
                this.bind(ProjectCacheImpl.class);
                this.bind(ProjectCache.class).to(ProjectCacheImpl.class);
                this.install(new LifecycleModule(){

                    @Override
                    protected void configure() {
                        this.listener().to(ProjectCacheWarmer.class);
                        this.listener().to(ProjectCacheClock.class);
                    }
                });
            }
        };
    }

    @Inject
    ProjectCacheImpl(AllProjectsName allProjectsName, AllUsersName allUsersName, @Named(value="projects") LoadingCache<String, ProjectState> byName, @Named(value="project_list") LoadingCache<ListKey, SortedSet<Project.NameKey>> list, ProjectCacheClock clock) {
        this.allProjectsName = allProjectsName;
        this.allUsersName = allUsersName;
        this.byName = byName;
        this.list = list;
        this.listLock = new ReentrantLock(true);
        this.clock = clock;
    }

    @Override
    public ProjectState getAllProjects() {
        ProjectState state = this.get(this.allProjectsName);
        if (state == null) {
            throw new IllegalStateException("Missing project " + this.allProjectsName);
        }
        return state;
    }

    @Override
    public ProjectState getAllUsers() {
        ProjectState state = this.get(this.allUsersName);
        if (state == null) {
            throw new IllegalStateException("Missing project " + this.allUsersName);
        }
        return state;
    }

    @Override
    public ProjectState get(Project.NameKey projectName) {
        try {
            return this.checkedGet(projectName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public ProjectState checkedGet(Project.NameKey projectName) throws IOException {
        if (projectName == null) {
            return null;
        }
        try {
            return this.strictCheckedGet(projectName);
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof RepositoryNotFoundException)) {
                log.warn("Cannot read project {}", (Object)projectName.get(), (Object)e);
                Throwables.throwIfInstanceOf(e.getCause(), IOException.class);
                throw new IOException(e);
            }
            log.debug("Cannot find project {}", (Object)projectName.get(), (Object)e);
            return null;
        }
    }

    @Override
    public ProjectState checkedGet(Project.NameKey projectName, boolean strict) throws Exception {
        return strict ? this.strictCheckedGet(projectName) : this.checkedGet(projectName);
    }

    private ProjectState strictCheckedGet(Project.NameKey projectName) throws Exception {
        ProjectState state = this.byName.get(projectName.get());
        if (state != null && state.needsRefresh(this.clock.read())) {
            this.byName.invalidate(projectName.get());
            state = this.byName.get(projectName.get());
        }
        return state;
    }

    @Override
    public void evict(Project p) {
        if (p != null) {
            this.byName.invalidate(p.getNameKey().get());
        }
    }

    @Override
    public void evict(Project.NameKey p) {
        if (p != null) {
            this.byName.invalidate(p.get());
        }
    }

    @Override
    public void remove(Project p) {
        this.remove(p.getNameKey());
    }

    @Override
    public void remove(Project.NameKey name) {
        this.listLock.lock();
        try {
            TreeSet n = Sets.newTreeSet((Iterable)this.list.get(ListKey.ALL));
            n.remove(name);
            this.list.put(ListKey.ALL, Collections.unmodifiableSortedSet(n));
        }
        catch (ExecutionException e) {
            log.warn("Cannot list available projects", e);
        }
        finally {
            this.listLock.unlock();
        }
        this.evict(name);
    }

    @Override
    public void onCreateProject(Project.NameKey newProjectName) {
        this.listLock.lock();
        try {
            TreeSet<Project.NameKey> n = Sets.newTreeSet((Iterable)this.list.get(ListKey.ALL));
            n.add(newProjectName);
            this.list.put(ListKey.ALL, Collections.unmodifiableSortedSet(n));
        }
        catch (ExecutionException e) {
            log.warn("Cannot list available projects", e);
        }
        finally {
            this.listLock.unlock();
        }
    }

    public SortedSet<Project.NameKey> all() {
        try {
            return this.list.get(ListKey.ALL);
        }
        catch (ExecutionException e) {
            log.warn("Cannot list available projects", e);
            return Collections.emptySortedSet();
        }
    }

    @Override
    public Set<AccountGroup.UUID> guessRelevantGroupUUIDs() {
        return this.all().stream().map(n -> (ProjectState)this.byName.getIfPresent(n.get())).filter(Objects::nonNull).flatMap(p -> p.getConfig().getAllGroupUUIDs().stream()).filter(id -> id != null && id.get() != null).collect(Collectors.toSet());
    }

    @Override
    public Iterable<Project.NameKey> byName(final String pfx) {
        SortedSet<Project.NameKey> src;
        try {
            src = this.list.get(ListKey.ALL).tailSet(new Project.NameKey(pfx));
        }
        catch (ExecutionException e) {
            return Collections.emptyList();
        }
        return new Iterable<Project.NameKey>(){

            @Override
            public Iterator<Project.NameKey> iterator() {
                return new Iterator<Project.NameKey>(){
                    private Iterator<Project.NameKey> itr;
                    private Project.NameKey next;
                    {
                        this.itr = src.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.next != null) {
                            return true;
                        }
                        if (!this.itr.hasNext()) {
                            return false;
                        }
                        Project.NameKey r = this.itr.next();
                        if (r.get().startsWith(pfx)) {
                            this.next = r;
                            return true;
                        }
                        this.itr = Collections.emptyList().iterator();
                        return false;
                    }

                    @Override
                    public Project.NameKey next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        Project.NameKey r = this.next;
                        this.next = null;
                        return r;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @VisibleForTesting
    public void evictAllByName() {
        this.byName.invalidateAll();
    }

    @VisibleForTesting
    public long sizeAllByName() {
        return this.byName.size();
    }

    static class Lister
    extends CacheLoader<ListKey, SortedSet<Project.NameKey>> {
        private final GitRepositoryManager mgr;

        @Inject
        Lister(GitRepositoryManager mgr) {
            this.mgr = mgr;
        }

        @Override
        public SortedSet<Project.NameKey> load(ListKey key) throws Exception {
            return this.mgr.list();
        }
    }

    static class ListKey {
        static final ListKey ALL = new ListKey();

        private ListKey() {
        }
    }

    static class Loader
    extends CacheLoader<String, ProjectState> {
        private final ProjectState.Factory projectStateFactory;
        private final GitRepositoryManager mgr;
        private final ProjectCacheClock clock;

        @Inject
        Loader(ProjectState.Factory psf, GitRepositoryManager g, ProjectCacheClock clock) {
            this.projectStateFactory = psf;
            this.mgr = g;
            this.clock = clock;
        }

        @Override
        public ProjectState load(String projectName) throws Exception {
            long now = this.clock.read();
            Project.NameKey key = new Project.NameKey(projectName);
            try (Repository git = this.mgr.openRepository(key);){
                ProjectConfig cfg = new ProjectConfig(key);
                cfg.load(git);
                ProjectState state = this.projectStateFactory.create(cfg);
                state.initLastCheck(now);
                ProjectState projectState = state;
                return projectState;
            }
        }
    }
}

