/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gerrit.index.IndexConfig;
import com.google.gerrit.index.query.InternalQuery;
import com.google.gerrit.index.query.Predicate;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.index.change.ChangeIndexCollection;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIdPredicate;
import com.google.gerrit.server.query.change.ChangeQueryProcessor;
import com.google.gerrit.server.query.change.ChangeStatusPredicate;
import com.google.gerrit.server.query.change.CommitPredicate;
import com.google.gerrit.server.query.change.ExactTopicPredicate;
import com.google.gerrit.server.query.change.GroupPredicate;
import com.google.gerrit.server.query.change.LegacyChangeIdPredicate;
import com.google.gerrit.server.query.change.ProjectPredicate;
import com.google.gerrit.server.query.change.RefPredicate;
import com.google.gerrit.server.query.change.SubmissionIdPredicate;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class InternalChangeQuery
extends InternalQuery<ChangeData> {
    private final ChangeData.Factory changeDataFactory;
    private final ChangeNotes.Factory notesFactory;

    private static Predicate<ChangeData> ref(Branch.NameKey branch) {
        return new RefPredicate(branch.get());
    }

    private static Predicate<ChangeData> change(Change.Key key) {
        return new ChangeIdPredicate(key.get());
    }

    private static Predicate<ChangeData> project(Project.NameKey project) {
        return new ProjectPredicate(project.get());
    }

    private static Predicate<ChangeData> status(Change.Status status) {
        return ChangeStatusPredicate.forStatus(status);
    }

    private static Predicate<ChangeData> commit(String id) {
        return new CommitPredicate(id);
    }

    @Inject
    InternalChangeQuery(ChangeQueryProcessor queryProcessor, ChangeIndexCollection indexes, IndexConfig indexConfig, ChangeData.Factory changeDataFactory, ChangeNotes.Factory notesFactory) {
        super(queryProcessor, indexes, indexConfig);
        this.changeDataFactory = changeDataFactory;
        this.notesFactory = notesFactory;
    }

    public InternalChangeQuery setLimit(int n) {
        super.setLimit(n);
        return this;
    }

    public InternalChangeQuery enforceVisibility(boolean enforce) {
        super.enforceVisibility(enforce);
        return this;
    }

    public InternalChangeQuery setRequestedFields(Set<String> fields) {
        super.setRequestedFields(fields);
        return this;
    }

    public InternalChangeQuery noFields() {
        super.noFields();
        return this;
    }

    public List<ChangeData> byKey(Change.Key key) throws OrmException {
        return this.byKeyPrefix(key.get());
    }

    public List<ChangeData> byKeyPrefix(String prefix) throws OrmException {
        return this.query(new ChangeIdPredicate(prefix));
    }

    public List<ChangeData> byLegacyChangeId(Change.Id id) throws OrmException {
        return this.query(new LegacyChangeIdPredicate(id));
    }

    public List<ChangeData> byLegacyChangeIds(Collection<Change.Id> ids) throws OrmException {
        ArrayList<LegacyChangeIdPredicate> preds = new ArrayList<LegacyChangeIdPredicate>(ids.size());
        for (Change.Id id : ids) {
            preds.add(new LegacyChangeIdPredicate(id));
        }
        return this.query(Predicate.or(preds));
    }

    public List<ChangeData> byBranchKey(Branch.NameKey branch, Change.Key key) throws OrmException {
        return this.query(Predicate.and(InternalChangeQuery.ref(branch), InternalChangeQuery.project(branch.getParentKey()), InternalChangeQuery.change(key)));
    }

    public List<ChangeData> byProject(Project.NameKey project) throws OrmException {
        return this.query(InternalChangeQuery.project(project));
    }

    public List<ChangeData> byBranchOpen(Branch.NameKey branch) throws OrmException {
        return this.query(Predicate.and(InternalChangeQuery.ref(branch), InternalChangeQuery.project(branch.getParentKey()), ChangeStatusPredicate.open()));
    }

    public List<ChangeData> byBranchNew(Branch.NameKey branch) throws OrmException {
        return this.query(Predicate.and(InternalChangeQuery.ref(branch), InternalChangeQuery.project(branch.getParentKey()), InternalChangeQuery.status(Change.Status.NEW)));
    }

    public Iterable<ChangeData> byCommitsOnBranchNotMerged(Repository repo, ReviewDb db, Branch.NameKey branch, Collection<String> hashes) throws OrmException, IOException {
        return this.byCommitsOnBranchNotMerged(repo, db, branch, hashes, this.indexConfig.maxTerms() - 3);
    }

    @VisibleForTesting
    Iterable<ChangeData> byCommitsOnBranchNotMerged(Repository repo, ReviewDb db, Branch.NameKey branch, Collection<String> hashes, int indexLimit) throws OrmException, IOException {
        if (hashes.size() > indexLimit) {
            return this.byCommitsOnBranchNotMergedFromDatabase(repo, db, branch, hashes);
        }
        return this.byCommitsOnBranchNotMergedFromIndex(branch, hashes);
    }

    private Iterable<ChangeData> byCommitsOnBranchNotMergedFromDatabase(Repository repo, ReviewDb db, Branch.NameKey branch, Collection<String> hashes) throws OrmException, IOException {
        HashSet<Change.Id> changeIds = Sets.newHashSetWithExpectedSize(hashes.size());
        String lastPrefix = null;
        for (Ref ref : repo.getRefDatabase().getRefs("refs/changes/").values()) {
            Change.Id id;
            String r = ref.getName();
            if (lastPrefix != null && r.startsWith(lastPrefix) || !hashes.contains(ref.getObjectId().name()) || (id = Change.Id.fromRef(r)) == null || !changeIds.add(id)) continue;
            lastPrefix = r.substring(0, r.lastIndexOf(47));
        }
        List<ChangeNotes> notes = this.notesFactory.create(db, branch.getParentKey(), changeIds, cn -> {
            Change c = cn.getChange();
            return c.getDest().equals(branch) && c.getStatus() != Change.Status.MERGED;
        });
        return Lists.transform(notes, n -> this.changeDataFactory.create(db, (ChangeNotes)n));
    }

    private Iterable<ChangeData> byCommitsOnBranchNotMergedFromIndex(Branch.NameKey branch, Collection<String> hashes) throws OrmException {
        return this.query(Predicate.and(InternalChangeQuery.ref(branch), InternalChangeQuery.project(branch.getParentKey()), Predicate.not(InternalChangeQuery.status(Change.Status.MERGED)), Predicate.or(InternalChangeQuery.commits(hashes))));
    }

    private static List<Predicate<ChangeData>> commits(Collection<String> hashes) {
        ArrayList<Predicate<ChangeData>> commits = new ArrayList<Predicate<ChangeData>>(hashes.size());
        for (String s : hashes) {
            commits.add(InternalChangeQuery.commit(s));
        }
        return commits;
    }

    public List<ChangeData> byProjectOpen(Project.NameKey project) throws OrmException {
        return this.query(Predicate.and(InternalChangeQuery.project(project), ChangeStatusPredicate.open()));
    }

    public List<ChangeData> byTopicOpen(String topic) throws OrmException {
        return this.query(Predicate.and(new ExactTopicPredicate(topic), ChangeStatusPredicate.open()));
    }

    public List<ChangeData> byCommit(ObjectId id) throws OrmException {
        return this.byCommit(id.name());
    }

    public List<ChangeData> byCommit(String hash) throws OrmException {
        return this.query(InternalChangeQuery.commit(hash));
    }

    public List<ChangeData> byProjectCommit(Project.NameKey project, ObjectId id) throws OrmException {
        return this.byProjectCommit(project, id.name());
    }

    public List<ChangeData> byProjectCommit(Project.NameKey project, String hash) throws OrmException {
        return this.query(Predicate.and(InternalChangeQuery.project(project), InternalChangeQuery.commit(hash)));
    }

    public List<ChangeData> byProjectCommits(Project.NameKey project, List<String> hashes) throws OrmException {
        int n = this.indexConfig.maxTerms() - 1;
        Preconditions.checkArgument(hashes.size() <= n, "cannot exceed %s commits", n);
        return this.query(Predicate.and(InternalChangeQuery.project(project), Predicate.or(InternalChangeQuery.commits(hashes))));
    }

    public List<ChangeData> byBranchCommit(String project, String branch, String hash) throws OrmException {
        return this.query(Predicate.and(new ProjectPredicate(project), new RefPredicate(branch), InternalChangeQuery.commit(hash)));
    }

    public List<ChangeData> byBranchCommit(Branch.NameKey branch, String hash) throws OrmException {
        return this.byBranchCommit(branch.getParentKey().get(), branch.get(), hash);
    }

    public List<ChangeData> bySubmissionId(String cs) throws OrmException {
        if (Strings.isNullOrEmpty(cs)) {
            return Collections.emptyList();
        }
        return this.query(new SubmissionIdPredicate(cs));
    }

    public List<ChangeData> byProjectGroups(Project.NameKey project, Collection<String> groups) throws OrmException {
        ArrayList<GroupPredicate> groupPredicates = new ArrayList<GroupPredicate>(groups.size());
        for (String g : groups) {
            groupPredicates.add(new GroupPredicate(g));
        }
        return this.query(Predicate.and(InternalChangeQuery.project(project), Predicate.or(groupPredicates)));
    }
}

