/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;

public class OwnerPredicate
extends ChangeIndexPredicate {
    protected final Account.Id id;

    public OwnerPredicate(Account.Id id) {
        super(ChangeField.OWNER, id.toString());
        this.id = id;
    }

    protected Account.Id getAccountId() {
        return this.id;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        return change != null && this.id.equals(change.getOwner());
    }

    @Override
    public int getCost() {
        return 1;
    }
}

