/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.schema.JdbcAccountPatchReviewStore;
import com.google.gerrit.server.schema.SchemaVersion;
import com.google.gerrit.server.schema.Schema_126;
import com.google.gerrit.server.schema.UpdateUI;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.jgit.lib.Config;

public class Schema_127
extends SchemaVersion {
    private static final int MAX_BATCH_SIZE = 1000;
    private final SitePaths sitePaths;
    private final Config cfg;
    private final ThreadSettingsConfig threadSettingsConfig;

    @Inject
    Schema_127(Provider<Schema_126> prior, SitePaths sitePaths, @GerritServerConfig Config cfg, ThreadSettingsConfig threadSettingsConfig) {
        super(prior);
        this.sitePaths = sitePaths;
        this.cfg = cfg;
        this.threadSettingsConfig = threadSettingsConfig;
    }

    @Override
    protected void migrateData(ReviewDb db, UpdateUI ui) throws OrmException {
        JdbcAccountPatchReviewStore jdbcAccountPatchReviewStore = JdbcAccountPatchReviewStore.createAccountPatchReviewStore(this.cfg, this.sitePaths, this.threadSettingsConfig);
        jdbcAccountPatchReviewStore.dropTableIfExists();
        jdbcAccountPatchReviewStore.createTableIfNotExists();
        try (Connection con = jdbcAccountPatchReviewStore.getConnection();
             PreparedStatement stmt = con.prepareStatement("INSERT INTO account_patch_reviews (account_id, change_id, patch_set_id, file_name) VALUES (?, ?, ?, ?)");){
            int batchCount = 0;
            try (Statement s = Schema_127.newStatement(db);
                 ResultSet rs = s.executeQuery("SELECT * from account_patch_reviews");){
                while (rs.next()) {
                    stmt.setInt(1, rs.getInt("account_id"));
                    stmt.setInt(2, rs.getInt("change_id"));
                    stmt.setInt(3, rs.getInt("patch_set_id"));
                    stmt.setString(4, rs.getString("file_name"));
                    stmt.addBatch();
                    if (++batchCount < 1000) continue;
                    stmt.executeBatch();
                    batchCount = 0;
                }
            }
            if (batchCount > 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw jdbcAccountPatchReviewStore.convertError("insert", e);
        }
    }
}

