/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.receive.AsyncReceiveCommits;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.permissions.ProjectPermission;
import com.google.gerrit.sshd.AbstractGitCommand;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshSession;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jgit.errors.TooLargeObjectInPackException;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.ReceivePack;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="receive-pack", description="Standard Git server side command for client side git push")
final class Receive
extends AbstractGitCommand {
    private static final Logger log = LoggerFactory.getLogger(Receive.class);
    @Inject
    private AsyncReceiveCommits.Factory factory;
    @Inject
    private IdentifiedUser currentUser;
    @Inject
    private SshSession session;
    @Inject
    private PermissionBackend permissionBackend;
    private final SetMultimap<ReviewerStateInternal, Account.Id> reviewers = MultimapBuilder.hashKeys(2).hashSetValues().build();

    Receive() {
    }

    @Option(name="--reviewer", aliases={"--re"}, metaVar="EMAIL", usage="request reviewer for change(s)")
    void addReviewer(Account.Id id) {
        this.reviewers.put(ReviewerStateInternal.REVIEWER, id);
    }

    @Option(name="--cc", aliases={}, metaVar="EMAIL", usage="CC user on change(s)")
    void addCC(Account.Id id) {
        this.reviewers.put(ReviewerStateInternal.CC, id);
    }

    @Override
    protected void runImpl() throws IOException, BaseCommand.Failure {
        try {
            this.permissionBackend.user(this.currentUser).project(this.project.getNameKey()).check(ProjectPermission.RUN_RECEIVE_PACK);
        }
        catch (AuthException e) {
            throw new BaseCommand.Failure(1, "fatal: receive-pack not permitted on this server");
        }
        catch (PermissionBackendException e) {
            throw new BaseCommand.Failure(1, "fatal: unable to check permissions " + e);
        }
        AsyncReceiveCommits arc = this.factory.create(this.projectControl, this.repo, null, this.reviewers);
        Capable r = arc.canUpload();
        if (r != Capable.OK) {
            throw this.die(r.getMessage());
        }
        ReceivePack rp = arc.getReceivePack();
        try {
            rp.receive(this.in, this.out, this.err);
            this.session.setPeerAgent(rp.getPeerUserAgent());
        }
        catch (UnpackException badStream) {
            if (badStream.getCause() instanceof TooLargeObjectInPackException) {
                StringBuilder msg = new StringBuilder();
                msg.append("Receive error on project \"").append(this.projectControl.getProject().getName()).append("\"");
                msg.append(" (user ");
                msg.append(this.currentUser.getAccount().getUserName());
                msg.append(" account ");
                msg.append(this.currentUser.getAccountId());
                msg.append("): ");
                msg.append(badStream.getCause().getMessage());
                log.info(msg.toString());
                throw new BaseCommand.UnloggedFailure(128, "error: " + badStream.getCause().getMessage());
            }
            StringBuilder msg = new StringBuilder();
            msg.append("Unpack error on project \"").append(this.projectControl.getProject().getName()).append("\":\n");
            msg.append("  AdvertiseRefsHook: ").append(rp.getAdvertiseRefsHook());
            if (rp.getAdvertiseRefsHook() == AdvertiseRefsHook.DEFAULT) {
                msg.append("DEFAULT");
            } else if (rp.getAdvertiseRefsHook() instanceof VisibleRefFilter) {
                msg.append("VisibleRefFilter");
            } else {
                msg.append(rp.getAdvertiseRefsHook().getClass());
            }
            msg.append("\n");
            if (rp.getAdvertiseRefsHook() instanceof VisibleRefFilter) {
                Map<String, Ref> adv = rp.getAdvertisedRefs();
                msg.append("  Visible references (").append(adv.size()).append("):\n");
                for (Ref ref : adv.values()) {
                    msg.append("  - ").append(ref.getObjectId().abbreviate(8).name()).append(" ").append(ref.getName()).append("\n");
                }
                Map<String, Ref> allRefs = rp.getRepository().getRefDatabase().getRefs("");
                ArrayList<Ref> hidden = new ArrayList<Ref>();
                for (Ref ref : allRefs.values()) {
                    if (adv.containsKey(ref.getName())) continue;
                    hidden.add(ref);
                }
                msg.append("  Hidden references (").append(hidden.size()).append("):\n");
                for (Ref ref : hidden) {
                    msg.append("  - ").append(ref.getObjectId().abbreviate(8).name()).append(" ").append(ref.getName()).append("\n");
                }
            }
            IOException detail = new IOException(msg.toString(), badStream);
            throw new BaseCommand.Failure(128, "fatal: Unpack error, check server log", detail);
        }
    }
}

