/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.DeleteReviewerInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.DeleteReviewer;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.ReviewerResource;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.ChangeArgumentParser;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CommandMetaData(name="set-reviewers", description="Add or remove reviewers on a change")
public class SetReviewersCommand
extends SshCommand {
    private static final Logger log = LoggerFactory.getLogger(SetReviewersCommand.class);
    @Option(name="--project", aliases={"-p"}, usage="project containing the change")
    private ProjectControl projectControl;
    @Option(name="--add", aliases={"-a"}, metaVar="REVIEWER", usage="user or group that should be added as reviewer")
    private List<String> toAdd = new ArrayList<String>();
    @Inject
    private ReviewerResource.Factory reviewerFactory;
    @Inject
    private PostReviewers postReviewers;
    @Inject
    private DeleteReviewer deleteReviewer;
    @Inject
    private ChangeArgumentParser changeArgumentParser;
    private Set<Account.Id> toRemove = new HashSet<Account.Id>();
    private Map<Change.Id, ChangeResource> changes = new LinkedHashMap<Change.Id, ChangeResource>();

    @Option(name="--remove", aliases={"-r"}, metaVar="REVIEWER", usage="user that should be removed from the reviewer list")
    void optionRemove(Account.Id who) {
        this.toRemove.add(who);
    }

    @Argument(index=0, required=true, multiValued=true, metaVar="CHANGE", usage="changes to modify")
    void addChange(String token) {
        try {
            this.changeArgumentParser.addChange(token, this.changes, this.projectControl);
        }
        catch (BaseCommand.UnloggedFailure e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (OrmException e) {
            throw new IllegalArgumentException("database is down", e);
        }
        catch (PermissionBackendException e) {
            throw new IllegalArgumentException("can't check permissions", e);
        }
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        boolean ok = true;
        for (ChangeResource rsrc : this.changes.values()) {
            try {
                ok &= this.modifyOne(rsrc);
            }
            catch (Exception err) {
                ok = false;
                log.error("Error updating reviewers on change " + rsrc.getId(), err);
                this.writeError("fatal", "internal error while updating " + rsrc.getId());
            }
        }
        if (!ok) {
            throw this.die("one or more updates failed; review output above");
        }
    }

    private boolean modifyOne(ChangeResource changeRsrc) throws Exception {
        String error;
        boolean ok = true;
        for (Account.Id id : this.toRemove) {
            ReviewerResource rsrc = this.reviewerFactory.create(changeRsrc, id);
            error = null;
            try {
                this.deleteReviewer.apply(rsrc, new DeleteReviewerInput());
            }
            catch (ResourceNotFoundException e) {
                error = String.format("could not remove %s: not found", id);
            }
            catch (Exception e) {
                error = String.format("could not remove %s: %s", id, e.getMessage());
            }
            if (error == null) continue;
            ok = false;
            this.writeError("error", error);
        }
        for (String string : this.toAdd) {
            AddReviewerInput input = new AddReviewerInput();
            input.reviewer = string;
            input.confirmed = true;
            try {
                error = ((AddReviewerResult)this.postReviewers.apply(changeRsrc, input)).error;
            }
            catch (Exception e) {
                error = String.format("could not add %s: %s", string, e.getMessage());
            }
            if (error == null) continue;
            ok = false;
            this.writeError("error", error);
        }
        return ok;
    }
}

