/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.restricted.MsgPartUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.Nullable;

final class RenderOnlySoyMsgBundleImpl
extends SoyMsgBundle {
    private final String localeString;
    private final ULocale locale;
    private final boolean isRtl;
    private final long[] idArray;
    private final ImmutableList<SoyMsgPart>[] valueArray;

    public RenderOnlySoyMsgBundleImpl(@Nullable String localeString, Iterable<SoyMsg> msgs) {
        this.localeString = localeString;
        this.locale = localeString == null ? null : new ULocale(localeString);
        this.isRtl = BidiGlobalDir.forStaticLocale(localeString) == BidiGlobalDir.RTL;
        TreeMap<Long, ImmutableList<SoyMsgPart>> partsMap = new TreeMap<Long, ImmutableList<SoyMsgPart>>();
        for (SoyMsg msg : msgs) {
            Preconditions.checkArgument(Objects.equals(msg.getLocaleString(), localeString));
            Preconditions.checkArgument(msg.getAltId() < 0L, "RenderOnlySoyMsgBundleImpl doesn't support alternate ID's.");
            long msgId = msg.getId();
            Preconditions.checkArgument(!partsMap.containsKey(msgId), "Duplicate messages are not permitted in the render-only impl.");
            ImmutableList<SoyMsgPart> parts = msg.getParts();
            Preconditions.checkArgument(MsgPartUtils.hasPlrselPart(parts) == msg.isPlrselMsg(), "Message's plural/select status is inconsistent -- internal compiler bug.");
            partsMap.put(msgId, parts);
        }
        this.idArray = new long[partsMap.size()];
        ImmutableList[] typedArray = new ImmutableList[partsMap.size()];
        this.valueArray = typedArray;
        int index = 0;
        for (Map.Entry entry : partsMap.entrySet()) {
            this.idArray[index] = (Long)entry.getKey();
            this.valueArray[index] = (ImmutableList)entry.getValue();
            ++index;
        }
        Preconditions.checkState(index == partsMap.size());
    }

    private SoyMsg resurrectMsg(long id, ImmutableList<SoyMsgPart> parts) {
        return SoyMsg.builder().setId(id).setLocaleString(this.localeString).setIsPlrselMsg(MsgPartUtils.hasPlrselPart(parts)).setParts(parts).build();
    }

    @Override
    public String getLocaleString() {
        return this.localeString;
    }

    @Override
    @Nullable
    public ULocale getLocale() {
        return this.locale;
    }

    @Override
    public boolean isRtl() {
        return this.isRtl;
    }

    @Override
    public SoyMsg getMsg(long msgId) {
        int index = Arrays.binarySearch(this.idArray, msgId);
        return index >= 0 ? this.resurrectMsg(msgId, this.valueArray[index]) : null;
    }

    @Override
    public ImmutableList<SoyMsgPart> getMsgParts(long msgId) {
        int index = Arrays.binarySearch(this.idArray, msgId);
        return index >= 0 ? this.valueArray[index] : ImmutableList.of();
    }

    @Override
    public int getNumMsgs() {
        return this.idArray.length;
    }

    @Override
    public Iterator<SoyMsg> iterator() {
        return new Iterator<SoyMsg>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < RenderOnlySoyMsgBundleImpl.this.idArray.length;
            }

            @Override
            public SoyMsg next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                SoyMsg result = RenderOnlySoyMsgBundleImpl.this.resurrectMsg(RenderOnlySoyMsgBundleImpl.this.idArray[this.index], RenderOnlySoyMsgBundleImpl.this.valueArray[this.index]);
                ++this.index;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Iterator is immutable");
            }
        };
    }
}

