/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.builtin;

import com.googlecode.prolog_cafe.exceptions.IllegalTypeException;
import com.googlecode.prolog_cafe.exceptions.PInstantiationException;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PRED_regex_match_3
extends Predicate.P3 {
    private static final Operation regex_check = new PRED_regex_check();
    private static final Operation regex_next = new PRED_regex_next();
    private static final Operation regex_empty = new PRED_regex_empty();

    public PRED_regex_match_3(Term term, Term term2, Term term3, Operation operation) {
        this.arg1 = term;
        this.arg2 = term2;
        this.arg3 = term3;
        this.cont = operation;
    }

    @Override
    public Operation exec(Prolog prolog) {
        prolog.setB0();
        prolog.cont = this.cont;
        Term term = this.arg1.dereference();
        Term term2 = this.arg2.dereference();
        if (term instanceof VariableTerm) {
            throw new PInstantiationException(this, 1);
        }
        Pattern pattern = (Pattern)((JavaObjectTerm)term).object();
        if (term2 instanceof VariableTerm) {
            throw new PInstantiationException(this, 1);
        }
        if (!(term2 instanceof SymbolTerm)) {
            throw new IllegalTypeException(this, 1, "atom", term2);
        }
        Matcher matcher = pattern.matcher(term2.name());
        if (!matcher.find()) {
            return prolog.fail();
        }
        prolog.r1 = new JavaObjectTerm(matcher);
        prolog.r2 = this.arg3;
        return prolog.jtry2(regex_check, regex_next);
    }

    private static Term getMatches(Matcher matcher) {
        Term term = Prolog.Nil;
        for (int i = matcher.groupCount(); i >= 0; --i) {
            SymbolTerm symbolTerm = SymbolTerm.create(matcher.group(i));
            term = new ListTerm(symbolTerm, term);
        }
        return term;
    }

    private static final class PRED_regex_empty
    extends Operation {
        private PRED_regex_empty() {
        }

        @Override
        public Operation exec(Prolog prolog) {
            Term term = prolog.r1;
            Matcher matcher = (Matcher)((JavaObjectTerm)term).object();
            if (!matcher.find()) {
                return prolog.fail();
            }
            return prolog.jtry2(regex_check, regex_next);
        }
    }

    private static final class PRED_regex_next
    extends Operation {
        private PRED_regex_next() {
        }

        @Override
        public Operation exec(Prolog prolog) {
            return prolog.trust(regex_empty);
        }
    }

    private static final class PRED_regex_check
    extends Operation {
        private PRED_regex_check() {
        }

        @Override
        public Operation exec(Prolog prolog) {
            Term term = prolog.r1;
            Term term2 = prolog.r2;
            Matcher matcher = (Matcher)((JavaObjectTerm)term).object();
            Term term3 = PRED_regex_match_3.getMatches(matcher);
            if (term3 == Prolog.Nil || !term2.unify(term3, prolog.trail)) {
                return prolog.fail();
            }
            return prolog.cont;
        }
    }
}

