/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.exceptions.PermissionException;
import com.googlecode.prolog_cafe.exceptions.SystemException;
import com.googlecode.prolog_cafe.lang.ChoicePointFrame;
import com.googlecode.prolog_cafe.lang.ChoicePointStack;
import com.googlecode.prolog_cafe.lang.DoubleTerm;
import com.googlecode.prolog_cafe.lang.Failure;
import com.googlecode.prolog_cafe.lang.HashtableOfTerm;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.InternalDatabase;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologControl;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;

public final class Prolog {
    public static final int MAX_ARITY = 10;
    private static final SymbolTerm NONE = SymbolTerm.intern("$none");
    public PrologControl control;
    public Term r1;
    public Term r2;
    public Term r3;
    public Term r4;
    public Term r5;
    public Term r6;
    public Term r7;
    public Term r8;
    public Term r9;
    public Term r10;
    public Operation cont;
    public final ChoicePointStack stack;
    public final Trail trail;
    public int B0;
    public PrologClassLoader pcl;
    public InternalDatabase internalDB;
    protected long CPFTimeStamp;
    public int halt;
    protected String debug;
    protected Term exception;
    protected long startRuntime;
    protected long previousRuntime;
    protected final IdentityHashMap<VariableTerm, VariableTerm> copyHash;
    public static final int PUSHBACK_SIZE = 3;
    protected HashtableOfTerm streamManager;
    protected final HashtableOfTerm hashManager;
    public static final String BUILTIN = "com.googlecode.prolog_cafe.builtin";
    public static final SymbolTerm Nil = SymbolTerm.intern("[]");
    protected final EnumSet<Feature> features = EnumSet.noneOf(Feature.class);

    Prolog(PrologControl prologControl) {
        this.control = prologControl;
        this.trail = new Trail();
        this.stack = new ChoicePointStack(this.trail);
        this.copyHash = new IdentityHashMap();
        this.hashManager = new HashtableOfTerm();
    }

    Prolog(PrologControl prologControl, PrologMachineCopy prologMachineCopy) {
        this.control = prologControl;
        this.trail = new Trail();
        this.stack = new ChoicePointStack(this.trail);
        this.copyHash = new IdentityHashMap();
        this.pcl = prologMachineCopy.pcl;
        this.hashManager = PrologMachineCopy.copyShallow(prologMachineCopy.hashManager);
        this.internalDB = new InternalDatabase(this, prologMachineCopy.internalDB, false);
    }

    private void initOnce() {
        if (this.pcl == null) {
            this.pcl = new PrologClassLoader();
        }
        if (this.internalDB == null) {
            this.internalDB = new InternalDatabase();
        }
        if (this.streamManager == null) {
            this.streamManager = new HashtableOfTerm(7);
        }
    }

    public void init() {
        this.initOnce();
        this.stack.init();
        this.trail.init();
        this.B0 = this.stack.top();
        this.CPFTimeStamp = Long.MIN_VALUE;
        ChoicePointFrame choicePointFrame = new ChoicePointFrame();
        choicePointFrame.b0 = this.B0;
        choicePointFrame.bp = Failure.FAILURE;
        choicePointFrame.tr = this.trail.top();
        choicePointFrame.timeStamp = ++this.CPFTimeStamp;
        this.stack.push(choicePointFrame);
        this.halt = 0;
        this.debug = "off";
        this.exception = NONE;
        this.startRuntime = this.features.contains((Object)Feature.STATISTICS) ? System.currentTimeMillis() : 0L;
        this.previousRuntime = 0L;
    }

    public void requireFeature(Feature feature, Operation operation, Term term) {
        if (!this.features.contains((Object)feature)) {
            throw new PermissionException(operation, "use", feature.toString().toLowerCase(), term, "disabled");
        }
    }

    public void setB0() {
        this.B0 = this.stack.top();
    }

    public void cut(int n) {
        this.stack.cut(n);
    }

    public void neckCut() {
        this.stack.cut(this.B0);
    }

    public Term copy(Term term) {
        this.copyHash.clear();
        return term.copy(this);
    }

    public Operation fail() {
        ChoicePointFrame choicePointFrame = this.stack.top;
        this.B0 = choicePointFrame.b0;
        return choicePointFrame.bp;
    }

    public Operation switch_on_term(Operation operation, Operation operation2, Operation operation3, Operation operation4, Operation operation5, Operation operation6) {
        switch (this.r1.dereference().type()) {
            case 0: {
                return operation;
            }
            case 1: {
                return operation2;
            }
            case 2: {
                return operation3;
            }
            case 3: {
                return operation4;
            }
            case 4: {
                return operation5;
            }
            case 5: {
                return operation6;
            }
        }
        return operation;
    }

    public Operation switch_on_hash(HashMap<Term, Operation> hashMap, Operation operation) {
        Term term;
        Term term2 = this.r1.dereference();
        if (term2 instanceof IntegerTerm || term2 instanceof DoubleTerm || term2 instanceof SymbolTerm) {
            term = term2;
        } else if (term2 instanceof StructureTerm) {
            term = ((StructureTerm)term2).functor();
        } else {
            throw new SystemException("Invalid argument in switch_on_hash");
        }
        Operation operation2 = hashMap.get(term);
        if (operation2 != null) {
            return operation2;
        }
        return operation;
    }

    public void restore() {
        this.stack.top.restore(this);
    }

    public Operation jtry0(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame());
    }

    public Operation jtry1(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S1(this));
    }

    public Operation jtry2(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S2(this));
    }

    public Operation jtry3(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S3(this));
    }

    public Operation jtry4(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S4(this));
    }

    public Operation jtry5(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S5(this));
    }

    public Operation jtry6(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S6(this));
    }

    public Operation jtry7(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S7(this));
    }

    public Operation jtry8(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S8(this));
    }

    public Operation jtry9(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S9(this));
    }

    public Operation jtry10(Operation operation, Operation operation2) {
        return this.jtry(operation, operation2, new ChoicePointFrame.S10(this));
    }

    private Operation jtry(Operation operation, Operation operation2, ChoicePointFrame choicePointFrame) {
        choicePointFrame.cont = this.cont;
        choicePointFrame.b0 = this.B0;
        choicePointFrame.bp = operation2;
        choicePointFrame.tr = this.trail.top();
        choicePointFrame.timeStamp = ++this.CPFTimeStamp;
        this.stack.push(choicePointFrame);
        return operation;
    }

    public Operation retry(Operation operation, Operation operation2) {
        this.restore();
        ChoicePointFrame choicePointFrame = this.stack.top;
        this.trail.unwind(choicePointFrame.tr);
        choicePointFrame.bp = operation2;
        return operation;
    }

    public Operation trust(Operation operation) {
        this.restore();
        this.trail.unwind(this.stack.top.tr);
        this.stack.delete();
        return operation;
    }

    public long getCPFTimeStamp() {
        return this.CPFTimeStamp;
    }

    public String getDebug() {
        return this.debug;
    }

    public void setDebug(String string) {
        this.debug = string;
    }

    public Term getException() {
        return this.exception;
    }

    public void setException(Term term) {
        this.exception = term;
    }

    public long getStartRuntime() {
        return this.startRuntime;
    }

    public long getPreviousRuntime() {
        return this.previousRuntime;
    }

    public void setPreviousRuntime(long l) {
        this.previousRuntime = l;
    }

    public HashtableOfTerm getStreamManager() {
        return this.streamManager;
    }

    public HashtableOfTerm getHashManager() {
        return this.hashManager;
    }

    public static enum Feature {
        IO,
        STATISTICS;

    }
}

