/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;

public class Chars {
    public static final char DEL_ERROR = '\ufdea';
    public static final char INS_ERROR = '\ufdeb';
    public static final char RESYNC = '\ufdec';
    public static final char RESYNC_START = '\ufded';
    public static final char RESYNC_END = '\ufdee';
    public static final char RESYNC_EOI = '\ufdef';
    public static final char EOI = '\uffff';
    @Deprecated
    public static final char INDENT = '\ufdd0';
    @Deprecated
    public static final char DEDENT = '\ufdd1';
    private static final Map<Character, String> ESCAPE_MAP = ImmutableMap.builder().put(Character.valueOf('\r'), "\\r").put(Character.valueOf('\n'), "\\n").put(Character.valueOf('\t'), "\\t").put(Character.valueOf('\f'), "\\f").put(Character.valueOf('\ufdea'), "DEL_ERROR").put(Character.valueOf('\ufdeb'), "INS_ERROR").put(Character.valueOf('\ufdec'), "RESYNC").put(Character.valueOf('\ufded'), "RESYNC_START").put(Character.valueOf('\ufdee'), "RESYNC_END").put(Character.valueOf('\ufdef'), "RESYNC_EOI").put(Character.valueOf('\ufdd0'), "INDENT").put(Character.valueOf('\ufdd1'), "DEDENT").put(Character.valueOf('\uffff'), "EOI").build();

    private Chars() {
    }

    public static Map<Character, String> escapeMap() {
        return ESCAPE_MAP;
    }

    public static String escape(char c) {
        return Optional.fromNullable(ESCAPE_MAP.get(Character.valueOf(c))).or(String.valueOf(c));
    }

    public static String repeat(char c, int n) {
        char[] array = new char[n];
        Arrays.fill(array, c);
        return new String(array);
    }
}

