/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.support;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.HashSet;
import java.util.Set;
import org.parboiled.Context;
import org.parboiled.Node;
import org.parboiled.Rule;
import org.parboiled.common.Tuple2;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MatcherUtils;
import org.parboiled.support.MatcherPath;
import org.parboiled.trees.GraphUtils;

public final class Filters {
    public static final Predicate<Node<Object>> SKIP_EMPTY_OPTS = new Predicate<Node<Object>>(){

        @Override
        public boolean apply(Node<Object> input) {
            return GraphUtils.hasChildren(input) || input.getEndIndex() != input.getStartIndex() || !"Optional".equals(input.getLabel());
        }
    };
    public static final Predicate<Node<Object>> SKIP_EMPTY_ZOMS = new Predicate<Node<Object>>(){

        @Override
        public boolean apply(Node<Object> input) {
            return GraphUtils.hasChildren(input) || input.getEndIndex() != input.getStartIndex() || !"ZeroOrMore".equals(input.getLabel());
        }
    };
    public static final Predicate<Node<Object>> SKIP_EMPTY_OPTS_AND_ZOMS = Predicates.and(SKIP_EMPTY_OPTS, SKIP_EMPTY_ZOMS);

    private Filters() {
    }

    public static Predicate<Matcher> preventLoops() {
        return new Predicate<Matcher>(){
            private final Set<Matcher> visited = new HashSet<Matcher>();

            @Override
            public boolean apply(Matcher input) {
                return this.visited.add(MatcherUtils.unwrap(input));
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> lines(final int firstLine, final int lastLine) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                int line = ((Context)input.a).getInputBuffer().getPosition((int)((Context)input.a).getCurrentIndex()).line;
                return firstLine <= line && line <= lastLine;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> fromLine(final int firstLine) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                return ((Context)input.a).getInputBuffer().getPosition((int)((Context)input.a).getCurrentIndex()).line >= firstLine;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> untilLine(final int lastLine) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> tuple) {
                return ((Context)tuple.a).getInputBuffer().getPosition((int)((Context)tuple.a).getCurrentIndex()).line <= lastLine;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> rules(final Rule ... rules) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                MatcherPath path = ((Context)input.a).getPath();
                for (Rule rule : rules) {
                    if (!path.contains((Matcher)rule)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyRules(final Rule ... rules) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                for (Rule rule : rules) {
                    if (((Context)input.a).getMatcher() != rule) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> rulesBelow(final Rule ... rules) {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                MatcherPath path = ((Context)input.a).getPath();
                for (Rule rule : rules) {
                    Matcher matcher = (Matcher)rule;
                    if (((Context)input.a).getMatcher() == matcher || !path.contains(matcher)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyMatches() {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                return (Boolean)input.b;
            }
        };
    }

    public static Predicate<Tuple2<Context<?>, Boolean>> onlyMismatches() {
        return new Predicate<Tuple2<Context<?>, Boolean>>(){

            @Override
            public boolean apply(Tuple2<Context<?>, Boolean> input) {
                return (Boolean)input.b == false;
            }
        };
    }
}

