/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServletResponseRecorder
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(HttpServletResponseWrapper.class);
    private static final String LOCATION_HEADER = "Location";
    private int status;
    private String statusMsg = "";
    private Map<String, String> headers = new HashMap<String, String>();

    public HttpServletResponseRecorder(HttpServletResponse response) {
        super(response);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.status = sc;
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.status = sc;
        this.statusMsg = msg;
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.status = 302;
        this.setHeader(LOCATION_HEADER, location);
    }

    @Override
    public void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.headers.put(name, value);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    void play() throws IOException {
        if (this.status != 0) {
            log.debug("Replaying {} {}", (Object)this.status, (Object)this.statusMsg);
            if (this.status == 302) {
                super.sendRedirect(this.headers.get(LOCATION_HEADER));
            } else {
                super.sendError(this.status, this.statusMsg);
            }
        }
    }
}

