/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.index;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.gerrit.index.FieldType;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.sql.Timestamp;

public final class FieldDef<I, T> {
    private final String name;
    private final FieldType<?> type;
    private final boolean stored;
    private final boolean repeatable;
    private final Getter<I, T> getter;

    public static Builder<String> exact(String name) {
        return new Builder<String>(FieldType.EXACT, name);
    }

    public static Builder<String> fullText(String name) {
        return new Builder<String>(FieldType.FULL_TEXT, name);
    }

    public static Builder<Integer> intRange(String name) {
        return new Builder<Integer>(FieldType.INTEGER_RANGE, name).stored();
    }

    public static Builder<Integer> integer(String name) {
        return new Builder<Integer>(FieldType.INTEGER, name);
    }

    public static Builder<String> prefix(String name) {
        return new Builder<String>(FieldType.PREFIX, name);
    }

    public static Builder<byte[]> storedOnly(String name) {
        return new Builder<byte[]>(FieldType.STORED_ONLY, name).stored();
    }

    public static Builder<Timestamp> timestamp(String name) {
        return new Builder<Timestamp>(FieldType.TIMESTAMP, name);
    }

    private FieldDef(String name, FieldType<?> type, boolean stored, boolean repeatable, Getter<I, T> getter) {
        Preconditions.checkArgument(!repeatable || type != FieldType.INTEGER_RANGE, "Range queries against repeated fields are unsupported");
        this.name = FieldDef.checkName(name);
        this.type = Preconditions.checkNotNull(type);
        this.stored = stored;
        this.repeatable = repeatable;
        this.getter = Preconditions.checkNotNull(getter);
    }

    private static String checkName(String name) {
        CharMatcher m = CharMatcher.anyOf("abcdefghijklmnopqrstuvwxyz0123456789_");
        Preconditions.checkArgument(name != null && m.matchesAllOf(name), "illegal field name: %s", (Object)name);
        return name;
    }

    public String getName() {
        return this.name;
    }

    public FieldType<?> getType() {
        return this.type;
    }

    public boolean isStored() {
        return this.stored;
    }

    public T get(I input) throws OrmException {
        try {
            return this.getter.get(input);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public static class Builder<T> {
        private final FieldType<T> type;
        private final String name;
        private boolean stored;

        public Builder(FieldType<T> type, String name) {
            this.type = Preconditions.checkNotNull(type);
            this.name = Preconditions.checkNotNull(name);
        }

        public Builder<T> stored() {
            this.stored = true;
            return this;
        }

        public <I> FieldDef<I, T> build(Getter<I, T> getter) {
            return new FieldDef(this.name, this.type, this.stored, false, getter);
        }

        public <I> FieldDef<I, Iterable<T>> buildRepeatable(Getter<I, Iterable<T>> getter) {
            return new FieldDef(this.name, this.type, this.stored, true, getter);
        }
    }

    @FunctionalInterface
    public static interface Getter<I, T> {
        public T get(I var1) throws OrmException, IOException;
    }
}

