/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.common.primitives.Ints;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.index.Index;
import com.google.gerrit.index.IndexDefinition;
import com.google.gerrit.index.Schema;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.index.GerritIndexStatus;
import com.google.gerrit.server.index.OnlineUpgradeListener;
import com.google.gerrit.server.index.VersionManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LuceneVersionManager
extends VersionManager {
    private static final Logger log = LoggerFactory.getLogger(LuceneVersionManager.class);

    static Path getDir(SitePaths sitePaths, String name, Schema<?> schema) {
        return sitePaths.index_dir.resolve(String.format("%s_%04d", name, schema.getVersion()));
    }

    @Inject
    LuceneVersionManager(@GerritServerConfig Config cfg, SitePaths sitePaths, DynamicSet<OnlineUpgradeListener> listeners, Collection<IndexDefinition<?, ?, ?>> defs) {
        super(sitePaths, listeners, defs, VersionManager.getOnlineUpgrade(cfg));
    }

    @Override
    protected <K, V, I extends Index<K, V>> TreeMap<Integer, VersionManager.Version<V>> scanVersions(IndexDefinition<K, V, I> def, GerritIndexStatus cfg) {
        TreeMap versions = new TreeMap();
        for (Schema schema : def.getSchemas().values()) {
            Path p = LuceneVersionManager.getDir(this.sitePaths, def.getName(), schema);
            boolean isDir = Files.isDirectory(p, new LinkOption[0]);
            if (Files.exists(p, new LinkOption[0]) && !isDir) {
                log.warn("Not a directory: {}", (Object)p.toAbsolutePath());
            }
            int v = schema.getVersion();
            versions.put(v, new VersionManager.Version(schema, v, isDir, cfg.getReady(def.getName(), v)));
        }
        String prefix = def.getName() + "_";
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(this.sitePaths.index_dir);){
            for (Path p : paths) {
                String n = p.getFileName().toString();
                if (!n.startsWith(prefix)) continue;
                String versionStr = n.substring(prefix.length());
                Integer v = Ints.tryParse(versionStr);
                if (v == null || versionStr.length() != 4) {
                    log.warn("Unrecognized version in index directory: {}", (Object)p.toAbsolutePath());
                    continue;
                }
                if (versions.containsKey(v)) continue;
                versions.put(v, new VersionManager.Version(null, v, true, cfg.getReady(def.getName(), v)));
            }
        }
        catch (IOException e) {
            log.error("Error scanning index directory: " + this.sitePaths.index_dir, e);
        }
        return versions;
    }
}

