/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.metrics.proc;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OperatingSystemMXBeanProvider {
    private static final Logger log = LoggerFactory.getLogger(OperatingSystemMXBeanProvider.class);
    private final OperatingSystemMXBean sys;
    private final Method getProcessCpuTime;
    private final Method getOpenFileDescriptorCount;

    private OperatingSystemMXBeanProvider(OperatingSystemMXBean sys) throws ReflectiveOperationException {
        this.sys = sys;
        this.getProcessCpuTime = sys.getClass().getMethod("getProcessCpuTime", new Class[0]);
        this.getProcessCpuTime.setAccessible(true);
        this.getOpenFileDescriptorCount = sys.getClass().getMethod("getOpenFileDescriptorCount", new Class[0]);
        this.getOpenFileDescriptorCount.setAccessible(true);
    }

    public long getProcessCpuTime() {
        try {
            return (Long)this.getProcessCpuTime.invoke((Object)this.sys, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return -1L;
        }
    }

    public long getOpenFileDescriptorCount() {
        try {
            return (Long)this.getOpenFileDescriptorCount.invoke((Object)this.sys, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return -1L;
        }
    }

    static class Factory {
        Factory() {
        }

        static OperatingSystemMXBeanProvider create() {
            OperatingSystemMXBean sys = ManagementFactory.getOperatingSystemMXBean();
            for (String name : Arrays.asList("com.sun.management.UnixOperatingSystemMXBean", "com.ibm.lang.management.UnixOperatingSystemMXBean")) {
                try {
                    Class<?> impl = Class.forName(name);
                    if (!impl.isInstance(sys)) continue;
                    return new OperatingSystemMXBeanProvider(sys);
                }
                catch (ReflectiveOperationException e) {
                    log.debug("No implementation for {}", (Object)name, (Object)e);
                }
            }
            log.warn("No implementation of UnixOperatingSystemMXBean found");
            return null;
        }
    }
}

