/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.prettify.common;

import java.util.ArrayList;
import java.util.List;

public class SparseFileContent {
    protected List<Range> ranges = new ArrayList<Range>();
    protected int size;
    private transient int currentRangeIdx;

    public int size() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public String get(int idx) {
        String line = this.getLine(idx);
        if (line == null) {
            throw new ArrayIndexOutOfBoundsException(idx);
        }
        return line;
    }

    public boolean contains(int idx) {
        return this.getLine(idx) != null;
    }

    public int first() {
        return this.ranges.isEmpty() ? this.size() : this.ranges.get((int)0).base;
    }

    public int next(int idx) {
        int high = this.ranges.size();
        if (this.currentRangeIdx < high) {
            Range cur = this.ranges.get(this.currentRangeIdx);
            if (cur.contains(idx + 1)) {
                return idx + 1;
            }
            if (++this.currentRangeIdx < high) {
                return this.ranges.get((int)this.currentRangeIdx).base;
            }
        }
        int low = 0;
        do {
            int mid;
            Range cur;
            if ((cur = this.ranges.get(mid = (low + high) / 2)).contains(idx)) {
                if (cur.contains(idx + 1)) {
                    this.currentRangeIdx = mid;
                    return idx + 1;
                }
                if (mid + 1 < this.ranges.size()) {
                    this.currentRangeIdx = mid + 1;
                    return this.ranges.get((int)this.currentRangeIdx).base;
                }
                return this.size();
            }
            if (idx < cur.base) {
                high = mid;
                continue;
            }
            low = mid + 1;
        } while (low < high);
        return this.size();
    }

    private String getLine(int idx) {
        int high = this.ranges.size();
        if (this.currentRangeIdx < high) {
            Range next;
            Range cur = this.ranges.get(this.currentRangeIdx);
            if (cur.contains(idx)) {
                return cur.get(idx);
            }
            if (++this.currentRangeIdx < high && (next = this.ranges.get(this.currentRangeIdx)).contains(idx)) {
                return next.get(idx);
            }
        }
        if (this.ranges.isEmpty()) {
            return null;
        }
        int low = 0;
        do {
            int mid;
            Range cur;
            if ((cur = this.ranges.get(mid = (low + high) / 2)).contains(idx)) {
                this.currentRangeIdx = mid;
                return cur.get(idx);
            }
            if (idx < cur.base) {
                high = mid;
                continue;
            }
            low = mid + 1;
        } while (low < high);
        return null;
    }

    public void addLine(int i, String content) {
        Range r;
        if (!this.ranges.isEmpty() && i == this.last().end()) {
            r = this.last();
        } else {
            r = new Range(i);
            this.ranges.add(r);
        }
        r.lines.add(content);
    }

    private Range last() {
        return this.ranges.get(this.ranges.size() - 1);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SparseFileContent[\n");
        for (Range r : this.ranges) {
            b.append("  ");
            b.append(r.toString());
            b.append('\n');
        }
        b.append("]");
        return b.toString();
    }

    static class Range {
        protected int base;
        protected List<String> lines;

        private Range(int b) {
            this.base = b;
            this.lines = new ArrayList<String>();
        }

        protected Range() {
        }

        private String get(int i) {
            return this.lines.get(i - this.base);
        }

        private int end() {
            return this.base + this.lines.size();
        }

        private boolean contains(int i) {
            return this.base <= i && i < this.end();
        }

        public String toString() {
            return "Range[" + this.base + "," + this.end() + ")";
        }
    }
}

