/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.rules;

import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.rules.StoredValue;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.project.ProjectCache;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.assistedinject.Assisted;
import com.googlecode.prolog_cafe.lang.BufferingPrologControl;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.PredicateEncoder;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrologEnvironment
extends BufferingPrologControl {
    private static final Logger log = LoggerFactory.getLogger(PrologEnvironment.class);
    private final Args args;
    private final Map<StoredValue<Object>, Object> storedValues;
    private List<Runnable> cleanup;

    @Inject
    PrologEnvironment(Args a, @Assisted PrologMachineCopy src) {
        super(src);
        this.setEnabled(EnumSet.allOf(Prolog.Feature.class), false);
        this.args = a;
        this.storedValues = new HashMap<StoredValue<Object>, Object>();
        this.cleanup = new LinkedList<Runnable>();
    }

    public Args getArgs() {
        return this.args;
    }

    @Override
    public void setPredicate(Predicate goal) {
        super.setPredicate(goal);
        int reductionLimit = this.args.reductionLimit(goal);
        log.debug("setting reductionLimit {}", (Object)reductionLimit);
        this.setReductionLimit(reductionLimit);
    }

    public <T> T get(StoredValue<T> sv) {
        return (T)this.storedValues.get(sv);
    }

    public <T> void set(StoredValue<T> sv, T obj) {
        this.storedValues.put(sv, obj);
    }

    public void copyStoredValues(PrologEnvironment child) {
        this.storedValues.putAll(child.storedValues);
        this.setCleanup(child.cleanup);
    }

    public void setCleanup(List<Runnable> newCleanupList) {
        newCleanupList.addAll(this.cleanup);
        this.cleanup = newCleanupList;
    }

    public void addToCleanup(Runnable task) {
        this.cleanup.add(task);
    }

    public void close() {
        Iterator<Runnable> i = this.cleanup.iterator();
        while (i.hasNext()) {
            try {
                i.next().run();
            }
            catch (Throwable err) {
                log.error("Failed to execute cleanup for PrologEnvironment", err);
            }
            i.remove();
        }
    }

    @Singleton
    public static class Args {
        private static final Class<Predicate> CONSULT_STREAM_2;
        private final ProjectCache projectCache;
        private final PermissionBackend permissionBackend;
        private final GitRepositoryManager repositoryManager;
        private final PatchListCache patchListCache;
        private final PatchSetInfoFactory patchSetInfoFactory;
        private final IdentifiedUser.GenericFactory userFactory;
        private final Provider<AnonymousUser> anonymousUser;
        private final int reductionLimit;
        private final int compileLimit;

        @Inject
        Args(ProjectCache projectCache, PermissionBackend permissionBackend, GitRepositoryManager repositoryManager, PatchListCache patchListCache, PatchSetInfoFactory patchSetInfoFactory, IdentifiedUser.GenericFactory userFactory, Provider<AnonymousUser> anonymousUser, @GerritServerConfig Config config) {
            this.projectCache = projectCache;
            this.permissionBackend = permissionBackend;
            this.repositoryManager = repositoryManager;
            this.patchListCache = patchListCache;
            this.patchSetInfoFactory = patchSetInfoFactory;
            this.userFactory = userFactory;
            this.anonymousUser = anonymousUser;
            int limit = config.getInt("rules", null, "reductionLimit", 100000);
            this.reductionLimit = limit <= 0 ? Integer.MAX_VALUE : limit;
            limit = config.getInt("rules", null, "compileReductionLimit", (int)Math.min(10L * (long)limit, Integer.MAX_VALUE));
            this.compileLimit = limit <= 0 ? Integer.MAX_VALUE : limit;
            log.info("reductionLimit: {}, compileLimit: {}", (Object)this.reductionLimit, (Object)this.compileLimit);
        }

        private int reductionLimit(Predicate goal) {
            if (goal.getClass() == CONSULT_STREAM_2) {
                return this.compileLimit;
            }
            return this.reductionLimit;
        }

        public ProjectCache getProjectCache() {
            return this.projectCache;
        }

        public PermissionBackend getPermissionBackend() {
            return this.permissionBackend;
        }

        public GitRepositoryManager getGitRepositoryManager() {
            return this.repositoryManager;
        }

        public PatchListCache getPatchListCache() {
            return this.patchListCache;
        }

        public PatchSetInfoFactory getPatchSetInfoFactory() {
            return this.patchSetInfoFactory;
        }

        public IdentifiedUser.GenericFactory getUserFactory() {
            return this.userFactory;
        }

        public AnonymousUser getAnonymousUser() {
            return this.anonymousUser.get();
        }

        static {
            try {
                Class<?> c = Class.forName(PredicateEncoder.encode("com.googlecode.prolog_cafe.builtin", "consult_stream", 2), false, RulesCache.class.getClassLoader());
                CONSULT_STREAM_2 = c;
            }
            catch (ClassNotFoundException e) {
                throw new LinkageError("cannot find predicate consult_stream", e);
            }
        }
    }

    public static interface Factory {
        public PrologEnvironment create(PrologMachineCopy var1);
    }
}

