/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.RemotePeer;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupMembership;
import com.google.gerrit.server.account.ListGroupMembership;
import com.google.gerrit.server.account.Realm;
import com.google.gerrit.server.config.AnonymousCowardName;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.config.DisableReverseDnsLookup;
import com.google.gerrit.server.group.SystemGroupBackend;
import com.google.inject.Inject;
import com.google.inject.OutOfScopeException;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Singleton;
import com.google.inject.util.Providers;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.SystemReader;

public class IdentifiedUser
extends CurrentUser {
    private static final GroupMembership registeredGroups = new ListGroupMembership(ImmutableSet.of(SystemGroupBackend.ANONYMOUS_USERS, SystemGroupBackend.REGISTERED_USERS));
    private final Provider<String> canonicalUrl;
    private final AccountCache accountCache;
    private final AuthConfig authConfig;
    private final Realm realm;
    private final GroupBackend groupBackend;
    private final String anonymousCowardName;
    private final Boolean disableReverseDnsLookup;
    private final Set<String> validEmails = Sets.newTreeSet(String.CASE_INSENSITIVE_ORDER);
    private final Provider<SocketAddress> remotePeerProvider;
    private final Account.Id accountId;
    private AccountState state;
    private boolean loadedAllEmails;
    private Set<String> invalidEmails;
    private GroupMembership effectiveGroups;
    private CurrentUser realUser;
    private Map<CurrentUser.PropertyKey<Object>, Object> properties;

    private IdentifiedUser(AuthConfig authConfig, Realm realm, String anonymousCowardName, Provider<String> canonicalUrl, AccountCache accountCache, GroupBackend groupBackend, Boolean disableReverseDnsLookup, @Nullable Provider<SocketAddress> remotePeerProvider, AccountState state, @Nullable CurrentUser realUser) {
        this(authConfig, realm, anonymousCowardName, canonicalUrl, accountCache, groupBackend, disableReverseDnsLookup, remotePeerProvider, state.getAccount().getId(), realUser);
        this.state = state;
    }

    private IdentifiedUser(AuthConfig authConfig, Realm realm, String anonymousCowardName, Provider<String> canonicalUrl, AccountCache accountCache, GroupBackend groupBackend, Boolean disableReverseDnsLookup, @Nullable Provider<SocketAddress> remotePeerProvider, Account.Id id, @Nullable CurrentUser realUser) {
        this.canonicalUrl = canonicalUrl;
        this.accountCache = accountCache;
        this.groupBackend = groupBackend;
        this.authConfig = authConfig;
        this.realm = realm;
        this.anonymousCowardName = anonymousCowardName;
        this.disableReverseDnsLookup = disableReverseDnsLookup;
        this.remotePeerProvider = remotePeerProvider;
        this.accountId = id;
        this.realUser = realUser != null ? realUser : this;
    }

    @Override
    public CurrentUser getRealUser() {
        return this.realUser;
    }

    @Override
    public boolean isImpersonating() {
        if (this.realUser == this) {
            return false;
        }
        return !this.realUser.isIdentifiedUser() || !this.realUser.getAccountId().equals(this.getAccountId());
    }

    public AccountState state() {
        if (this.state == null) {
            this.state = this.accountCache.get(this.getAccountId());
        }
        return this.state;
    }

    @Override
    public IdentifiedUser asIdentifiedUser() {
        return this;
    }

    @Override
    public Account.Id getAccountId() {
        return this.accountId;
    }

    @Override
    public String getUserName() {
        return this.state().getUserName();
    }

    public Account getAccount() {
        return this.state().getAccount();
    }

    public boolean hasEmailAddress(String email) {
        if (this.validEmails.contains(email)) {
            return true;
        }
        if (this.invalidEmails != null && this.invalidEmails.contains(email)) {
            return false;
        }
        if (this.realm.hasEmailAddress(this, email)) {
            this.validEmails.add(email);
            return true;
        }
        if (this.invalidEmails == null) {
            this.invalidEmails = Sets.newTreeSet(String.CASE_INSENSITIVE_ORDER);
        }
        this.invalidEmails.add(email);
        return false;
    }

    public Set<String> getEmailAddresses() {
        if (!this.loadedAllEmails) {
            this.validEmails.addAll(this.realm.getEmailAddresses(this));
            this.loadedAllEmails = true;
        }
        return this.validEmails;
    }

    public String getName() {
        return this.getAccount().getName(this.anonymousCowardName);
    }

    public String getNameEmail() {
        return this.getAccount().getNameEmail(this.anonymousCowardName);
    }

    @Override
    public GroupMembership getEffectiveGroups() {
        if (this.effectiveGroups == null) {
            this.effectiveGroups = this.authConfig.isIdentityTrustable(this.state().getExternalIds()) ? this.groupBackend.membershipsOf(this) : registeredGroups;
        }
        return this.effectiveGroups;
    }

    public PersonIdent newRefLogIdent() {
        return this.newRefLogIdent(new Date(), TimeZone.getDefault());
    }

    public PersonIdent newRefLogIdent(Date when, TimeZone tz) {
        String user;
        Account ua = this.getAccount();
        String name = ua.getFullName();
        if (name == null || name.isEmpty()) {
            name = ua.getPreferredEmail();
        }
        if (name == null || name.isEmpty()) {
            name = this.anonymousCowardName;
        }
        if ((user = this.getUserName()) == null) {
            user = "";
        }
        user = user + "|account-" + ua.getId().toString();
        return new PersonIdent(name, user + "@" + this.guessHost(), when, tz);
    }

    public PersonIdent newCommitterIdent(Date when, TimeZone tz) {
        Account ua = this.getAccount();
        String name = ua.getFullName();
        String email = ua.getPreferredEmail();
        if (email == null || email.isEmpty()) {
            String host;
            String user = this.getUserName();
            if (user == null || user.isEmpty()) {
                user = "account-" + ua.getId().toString();
            }
            if (this.canonicalUrl.get() != null) {
                try {
                    host = new URL(this.canonicalUrl.get()).getHost();
                }
                catch (MalformedURLException e) {
                    host = SystemReader.getInstance().getHostname();
                }
            } else {
                host = SystemReader.getInstance().getHostname();
            }
            email = user + "@" + host;
        }
        if (name == null || name.isEmpty()) {
            int at = email.indexOf(64);
            name = 0 < at ? email.substring(0, at) : this.anonymousCowardName;
        }
        return new PersonIdent(name, email, when, tz);
    }

    public String toString() {
        return "IdentifiedUser[account " + this.getAccountId() + "]";
    }

    @Override
    public boolean isIdentifiedUser() {
        return true;
    }

    @Override
    @Nullable
    public synchronized <T> T get(CurrentUser.PropertyKey<T> key) {
        if (this.properties != null) {
            Object value = this.properties.get(key);
            return (T)value;
        }
        return null;
    }

    @Override
    public synchronized <T> void put(CurrentUser.PropertyKey<T> key, @Nullable T value) {
        if (this.properties == null) {
            if (value == null) {
                return;
            }
            this.properties = new HashMap<CurrentUser.PropertyKey<Object>, Object>();
        }
        CurrentUser.PropertyKey<T> k = key;
        if (value != null) {
            this.properties.put(k, value);
        } else {
            this.properties.remove(k);
        }
    }

    public IdentifiedUser materializedCopy() {
        Provider<SocketAddress> remotePeer;
        try {
            remotePeer = Providers.of(this.remotePeerProvider.get());
        }
        catch (OutOfScopeException | ProvisionException e) {
            remotePeer = new Provider<SocketAddress>(){

                @Override
                public SocketAddress get() {
                    throw e;
                }
            };
        }
        return new IdentifiedUser(this.authConfig, this.realm, this.anonymousCowardName, Providers.of(this.canonicalUrl.get()), this.accountCache, this.groupBackend, this.disableReverseDnsLookup, remotePeer, this.state, this.realUser);
    }

    @Override
    public boolean hasSameAccountId(CurrentUser other) {
        return this.getAccountId().get() == other.getAccountId().get();
    }

    private String guessHost() {
        String host = null;
        SocketAddress remotePeer = null;
        try {
            remotePeer = this.remotePeerProvider.get();
        }
        catch (OutOfScopeException | ProvisionException runtimeException) {
            // empty catch block
        }
        if (remotePeer instanceof InetSocketAddress) {
            InetSocketAddress sa = (InetSocketAddress)remotePeer;
            InetAddress in = sa.getAddress();
            String string = host = in != null ? this.getHost(in) : sa.getHostName();
        }
        if (Strings.isNullOrEmpty(host)) {
            return "unknown";
        }
        return host;
    }

    private String getHost(InetAddress in) {
        if (Boolean.FALSE.equals(this.disableReverseDnsLookup)) {
            return in.getCanonicalHostName();
        }
        return in.getHostAddress();
    }

    @Singleton
    public static class RequestFactory {
        private final AuthConfig authConfig;
        private final Realm realm;
        private final String anonymousCowardName;
        private final Provider<String> canonicalUrl;
        private final AccountCache accountCache;
        private final GroupBackend groupBackend;
        private final Boolean disableReverseDnsLookup;
        private final Provider<SocketAddress> remotePeerProvider;

        @Inject
        RequestFactory(AuthConfig authConfig, Realm realm, @AnonymousCowardName String anonymousCowardName, @CanonicalWebUrl Provider<String> canonicalUrl, AccountCache accountCache, GroupBackend groupBackend, @DisableReverseDnsLookup Boolean disableReverseDnsLookup, @RemotePeer Provider<SocketAddress> remotePeerProvider) {
            this.authConfig = authConfig;
            this.realm = realm;
            this.anonymousCowardName = anonymousCowardName;
            this.canonicalUrl = canonicalUrl;
            this.accountCache = accountCache;
            this.groupBackend = groupBackend;
            this.disableReverseDnsLookup = disableReverseDnsLookup;
            this.remotePeerProvider = remotePeerProvider;
        }

        public IdentifiedUser create(Account.Id id) {
            return new IdentifiedUser(this.authConfig, this.realm, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, this.disableReverseDnsLookup, this.remotePeerProvider, id, null);
        }

        public IdentifiedUser runAs(Account.Id id, CurrentUser caller) {
            return new IdentifiedUser(this.authConfig, this.realm, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, this.disableReverseDnsLookup, this.remotePeerProvider, id, caller);
        }
    }

    @Singleton
    public static class GenericFactory {
        private final AuthConfig authConfig;
        private final Realm realm;
        private final String anonymousCowardName;
        private final Provider<String> canonicalUrl;
        private final AccountCache accountCache;
        private final GroupBackend groupBackend;
        private final Boolean disableReverseDnsLookup;

        @Inject
        public GenericFactory(AuthConfig authConfig, Realm realm, @AnonymousCowardName String anonymousCowardName, @CanonicalWebUrl Provider<String> canonicalUrl, @DisableReverseDnsLookup Boolean disableReverseDnsLookup, AccountCache accountCache, GroupBackend groupBackend) {
            this.authConfig = authConfig;
            this.realm = realm;
            this.anonymousCowardName = anonymousCowardName;
            this.canonicalUrl = canonicalUrl;
            this.accountCache = accountCache;
            this.groupBackend = groupBackend;
            this.disableReverseDnsLookup = disableReverseDnsLookup;
        }

        public IdentifiedUser create(AccountState state) {
            return new IdentifiedUser(this.authConfig, this.realm, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, this.disableReverseDnsLookup, Providers.of(null), state, null);
        }

        public IdentifiedUser create(Account.Id id) {
            return this.create(null, id);
        }

        public IdentifiedUser create(SocketAddress remotePeer, Account.Id id) {
            return this.runAs(remotePeer, id, null);
        }

        public IdentifiedUser runAs(SocketAddress remotePeer, Account.Id id, @Nullable CurrentUser caller) {
            return new IdentifiedUser(this.authConfig, this.realm, this.anonymousCowardName, this.canonicalUrl, this.accountCache, this.groupBackend, this.disableReverseDnsLookup, Providers.of(remotePeer), id, caller);
        }
    }
}

