/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.AutoValue_StarredChangesUtil_StarField;
import com.google.gerrit.server.AutoValue_StarredChangesUtil_StarRef;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StarredChangesUtil {
    private static final Logger log = LoggerFactory.getLogger(StarredChangesUtil.class);
    public static final String DEFAULT_LABEL = "star";
    public static final String IGNORE_LABEL = "ignore";
    public static final String REVIEWED_LABEL = "reviewed";
    public static final String UNREVIEWED_LABEL = "unreviewed";
    public static final ImmutableSortedSet<String> DEFAULT_LABELS = ImmutableSortedSet.of("star");
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated gitRefUpdated;
    private final AllUsersName allUsers;
    private final Provider<ReviewDb> dbProvider;
    private final PersonIdent serverIdent;
    private final ChangeIndexer indexer;
    private final Provider<InternalChangeQuery> queryProvider;

    @Inject
    StarredChangesUtil(GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated, AllUsersName allUsers, Provider<ReviewDb> dbProvider, @GerritPersonIdent PersonIdent serverIdent, ChangeIndexer indexer, Provider<InternalChangeQuery> queryProvider) {
        this.repoManager = repoManager;
        this.gitRefUpdated = gitRefUpdated;
        this.allUsers = allUsers;
        this.dbProvider = dbProvider;
        this.serverIdent = serverIdent;
        this.indexer = indexer;
        this.queryProvider = queryProvider;
    }

    public ImmutableSortedSet<String> getLabels(Account.Id accountId, Change.Id changeId) throws OrmException {
        Repository repo = this.repoManager.openRepository(this.allUsers);
        try {
            ImmutableSortedSet<String> immutableSortedSet = StarredChangesUtil.readLabels(repo, RefNames.refsStarredChanges(changeId, accountId)).labels();
            if (repo != null) {
                repo.close();
            }
            return immutableSortedSet;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OrmException(String.format("Reading stars from change %d for account %d failed", changeId.get(), accountId.get()), e);
            }
        }
    }

    public ImmutableSortedSet<String> star(Account.Id accountId, Project.NameKey project, Change.Id changeId, Set<String> labelsToAdd, Set<String> labelsToRemove) throws OrmException, IllegalLabelException {
        Repository repo = this.repoManager.openRepository(this.allUsers);
        try {
            String refName = RefNames.refsStarredChanges(changeId, accountId);
            StarRef old = StarredChangesUtil.readLabels(repo, refName);
            HashSet<String> labels = new HashSet<String>(old.labels());
            if (labelsToAdd != null) {
                labels.addAll(labelsToAdd);
            }
            if (labelsToRemove != null) {
                labels.removeAll(labelsToRemove);
            }
            if (labels.isEmpty()) {
                this.deleteRef(repo, refName, old.objectId());
            } else {
                StarredChangesUtil.checkMutuallyExclusiveLabels(labels);
                this.updateLabels(repo, refName, old.objectId(), labels);
            }
            this.indexer.index(this.dbProvider.get(), project, changeId);
            ImmutableSortedSet<String> immutableSortedSet = ImmutableSortedSet.copyOf(labels);
            if (repo != null) {
                repo.close();
            }
            return immutableSortedSet;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OrmException(String.format("Star change %d for account %d failed", changeId.get(), accountId.get()), e);
            }
        }
    }

    public void unstarAll(Project.NameKey project, Change.Id changeId) throws OrmException {
        try (Repository repo = this.repoManager.openRepository(this.allUsers);
             RevWalk rw = new RevWalk(repo);){
            BatchRefUpdate batchUpdate = repo.getRefDatabase().newBatchUpdate();
            batchUpdate.setAllowNonFastForwards(true);
            batchUpdate.setRefLogIdent(this.serverIdent);
            batchUpdate.setRefLogMessage("Unstar change " + changeId.get(), true);
            for (Account.Id accountId : this.byChangeFromIndex(changeId).keySet()) {
                String refName = RefNames.refsStarredChanges(changeId, accountId);
                Ref ref = repo.getRefDatabase().getRef(refName);
                batchUpdate.addCommand(new ReceiveCommand(ref.getObjectId(), ObjectId.zeroId(), refName));
            }
            batchUpdate.execute(rw, NullProgressMonitor.INSTANCE);
            for (ReceiveCommand command : batchUpdate.getCommands()) {
                if (command.getResult() == ReceiveCommand.Result.OK) continue;
                throw new IOException(String.format("Unstar change %d failed, ref %s could not be deleted: %s", new Object[]{changeId.get(), command.getRefName(), command.getResult()}));
            }
            this.indexer.index(this.dbProvider.get(), project, changeId);
        }
        catch (IOException e) {
            throw new OrmException(String.format("Unstar change %d failed", changeId.get()), e);
        }
    }

    public ImmutableMap<Account.Id, StarRef> byChange(Change.Id changeId) throws OrmException {
        Repository repo = this.repoManager.openRepository(this.allUsers);
        try {
            ImmutableMap.Builder<Account.Id, StarRef> builder = ImmutableMap.builder();
            for (String refPart : StarredChangesUtil.getRefNames(repo, RefNames.refsStarredChangesPrefix(changeId))) {
                Integer id = Ints.tryParse(refPart);
                if (id == null) continue;
                Account.Id accountId = new Account.Id(id);
                builder.put(accountId, StarredChangesUtil.readLabels(repo, RefNames.refsStarredChanges(changeId, accountId)));
            }
            ImmutableMap immutableMap = builder.build();
            if (repo != null) {
                repo.close();
            }
            return immutableMap;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new OrmException(String.format("Get accounts that starred change %d failed", changeId.get()), e);
            }
        }
    }

    public ImmutableListMultimap<Account.Id, String> byChangeFromIndex(Change.Id changeId) throws OrmException {
        ImmutableSet<String> fields = ImmutableSet.of(ChangeField.ID.getName(), ChangeField.STAR.getName());
        List<ChangeData> changeData = ((InternalChangeQuery)this.queryProvider.get().setRequestedFields(fields)).byLegacyChangeId(changeId);
        if (changeData.size() != 1) {
            throw new NoSuchChangeException(changeId);
        }
        return changeData.get(0).stars();
    }

    private static Set<String> getRefNames(Repository repo, String prefix) throws IOException {
        RefDatabase refDb = repo.getRefDatabase();
        return refDb.getRefs(prefix).keySet();
    }

    public ObjectId getObjectId(Account.Id accountId, Change.Id changeId) {
        Repository repo = this.repoManager.openRepository(this.allUsers);
        try {
            ObjectId objectId;
            Ref ref = repo.exactRef(RefNames.refsStarredChanges(changeId, accountId));
            ObjectId objectId2 = objectId = ref != null ? ref.getObjectId() : ObjectId.zeroId();
            if (repo != null) {
                repo.close();
            }
            return objectId;
        }
        catch (Throwable throwable) {
            try {
                if (repo != null) {
                    try {
                        repo.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Getting star object ID for account {} on change {} failed", accountId.get(), changeId.get(), e);
                return ObjectId.zeroId();
            }
        }
    }

    public void ignore(ChangeResource rsrc) throws OrmException, IllegalLabelException {
        this.star(rsrc.getUser().asIdentifiedUser().getAccountId(), rsrc.getProject(), rsrc.getChange().getId(), ImmutableSet.of(IGNORE_LABEL), ImmutableSet.of());
    }

    public void unignore(ChangeResource rsrc) throws OrmException, IllegalLabelException {
        this.star(rsrc.getUser().asIdentifiedUser().getAccountId(), rsrc.getProject(), rsrc.getChange().getId(), ImmutableSet.of(), ImmutableSet.of(IGNORE_LABEL));
    }

    public boolean isIgnoredBy(Change.Id changeId, Account.Id accountId) throws OrmException {
        return this.getLabels(accountId, changeId).contains(IGNORE_LABEL);
    }

    public boolean isIgnored(ChangeResource rsrc) throws OrmException {
        return this.isIgnoredBy(rsrc.getChange().getId(), rsrc.getUser().asIdentifiedUser().getAccountId());
    }

    private static String getReviewedLabel(Change change) {
        return StarredChangesUtil.getReviewedLabel(change.currentPatchSetId().get());
    }

    private static String getReviewedLabel(int ps) {
        return "reviewed/" + ps;
    }

    private static String getUnreviewedLabel(Change change) {
        return StarredChangesUtil.getUnreviewedLabel(change.currentPatchSetId().get());
    }

    private static String getUnreviewedLabel(int ps) {
        return "unreviewed/" + ps;
    }

    public void markAsReviewed(ChangeResource rsrc) throws OrmException, IllegalLabelException {
        this.star(rsrc.getUser().asIdentifiedUser().getAccountId(), rsrc.getProject(), rsrc.getChange().getId(), ImmutableSet.of(StarredChangesUtil.getReviewedLabel(rsrc.getChange())), ImmutableSet.of(StarredChangesUtil.getUnreviewedLabel(rsrc.getChange())));
    }

    public void markAsUnreviewed(ChangeResource rsrc) throws OrmException, IllegalLabelException {
        this.star(rsrc.getUser().asIdentifiedUser().getAccountId(), rsrc.getProject(), rsrc.getChange().getId(), ImmutableSet.of(StarredChangesUtil.getUnreviewedLabel(rsrc.getChange())), ImmutableSet.of(StarredChangesUtil.getReviewedLabel(rsrc.getChange())));
    }

    public static StarRef readLabels(Repository repo, String refName) throws IOException {
        Ref ref = repo.exactRef(refName);
        if (ref == null) {
            return StarRef.MISSING;
        }
        try (ObjectReader reader = repo.newObjectReader();){
            ObjectLoader obj = reader.open(ref.getObjectId(), 3);
            StarRef starRef = StarRef.create(ref, Splitter.on(CharMatcher.whitespace()).omitEmptyStrings().split(new String(obj.getCachedBytes(Integer.MAX_VALUE), StandardCharsets.UTF_8)));
            return starRef;
        }
    }

    public static ObjectId writeLabels(Repository repo, Collection<String> labels) throws IOException, InvalidLabelsException {
        StarredChangesUtil.validateLabels(labels);
        try (ObjectInserter oi = repo.newObjectInserter();){
            ObjectId id = oi.insert(3, labels.stream().sorted().distinct().collect(Collectors.joining("\n")).getBytes(StandardCharsets.UTF_8));
            oi.flush();
            ObjectId objectId = id;
            return objectId;
        }
    }

    private static void checkMutuallyExclusiveLabels(Set<String> labels) throws MutuallyExclusiveLabelsException {
        Set<Integer> unreviewedPatchSets;
        if (labels.containsAll(ImmutableSet.of(DEFAULT_LABEL, IGNORE_LABEL))) {
            throw new MutuallyExclusiveLabelsException(DEFAULT_LABEL, IGNORE_LABEL);
        }
        Set<Integer> reviewedPatchSets = StarredChangesUtil.getStarredPatchSets(labels, REVIEWED_LABEL);
        Optional ps = Sets.intersection(reviewedPatchSets, unreviewedPatchSets = StarredChangesUtil.getStarredPatchSets(labels, UNREVIEWED_LABEL)).stream().findFirst();
        if (ps.isPresent()) {
            throw new MutuallyExclusiveLabelsException(StarredChangesUtil.getReviewedLabel((Integer)ps.get()), StarredChangesUtil.getUnreviewedLabel((Integer)ps.get()));
        }
    }

    public static Set<Integer> getStarredPatchSets(Set<String> labels, String label) {
        return labels.stream().filter(l -> l.startsWith(label)).filter(l -> Ints.tryParse(l.substring(label.length() + 1)) != null).map(l -> Integer.valueOf(l.substring(label.length() + 1))).collect(Collectors.toSet());
    }

    private static void validateLabels(Collection<String> labels) throws InvalidLabelsException {
        if (labels == null) {
            return;
        }
        TreeSet<String> invalidLabels = new TreeSet<String>();
        for (String label : labels) {
            if (!CharMatcher.whitespace().matchesAnyOf(label)) continue;
            invalidLabels.add(label);
        }
        if (!invalidLabels.isEmpty()) {
            throw new InvalidLabelsException(invalidLabels);
        }
    }

    private void updateLabels(Repository repo, String refName, ObjectId oldObjectId, Collection<String> labels) throws IOException, OrmException, InvalidLabelsException {
        try (RevWalk rw = new RevWalk(repo);){
            RefUpdate u = repo.updateRef(refName);
            u.setExpectedOldObjectId(oldObjectId);
            u.setForceUpdate(true);
            u.setNewObjectId(StarredChangesUtil.writeLabels(repo, labels));
            u.setRefLogIdent(this.serverIdent);
            u.setRefLogMessage("Update star labels", true);
            RefUpdate.Result result = u.update(rw);
            switch (result) {
                case NEW: 
                case FORCED: 
                case NO_CHANGE: 
                case FAST_FORWARD: {
                    this.gitRefUpdated.fire((Project.NameKey)this.allUsers, u, null);
                    return;
                }
            }
            throw new OrmException(String.format("Update star labels on ref %s failed: %s", refName, result.name()));
        }
    }

    private void deleteRef(Repository repo, String refName, ObjectId oldObjectId) throws IOException, OrmException {
        if (ObjectId.zeroId().equals(oldObjectId)) {
            return;
        }
        RefUpdate u = repo.updateRef(refName);
        u.setForceUpdate(true);
        u.setExpectedOldObjectId(oldObjectId);
        u.setRefLogIdent(this.serverIdent);
        u.setRefLogMessage("Unstar change", true);
        RefUpdate.Result result = u.delete();
        switch (result) {
            case FORCED: {
                this.gitRefUpdated.fire((Project.NameKey)this.allUsers, u, null);
                return;
            }
        }
        throw new OrmException(String.format("Delete star ref %s failed: %s", refName, result.name()));
    }

    public static class MutuallyExclusiveLabelsException
    extends IllegalLabelException {
        private static final long serialVersionUID = 1L;

        MutuallyExclusiveLabelsException(String label1, String label2) {
            super(String.format("The labels %s and %s are mutually exclusive. Only one of them can be set.", label1, label2));
        }
    }

    public static class InvalidLabelsException
    extends IllegalLabelException {
        private static final long serialVersionUID = 1L;

        InvalidLabelsException(Set<String> invalidLabels) {
            super(String.format("invalid labels: %s", Joiner.on(", ").join(invalidLabels)));
        }
    }

    public static class IllegalLabelException
    extends Exception {
        private static final long serialVersionUID = 1L;

        IllegalLabelException(String message) {
            super(message);
        }
    }

    @AutoValue
    public static abstract class StarRef {
        private static final StarRef MISSING = new AutoValue_StarredChangesUtil_StarRef(null, ImmutableSortedSet.of());

        private static StarRef create(Ref ref, Iterable<String> labels) {
            return new AutoValue_StarredChangesUtil_StarRef(Preconditions.checkNotNull(ref), ImmutableSortedSet.copyOf(labels));
        }

        @Nullable
        public abstract Ref ref();

        public abstract ImmutableSortedSet<String> labels();

        public ObjectId objectId() {
            return this.ref() != null ? this.ref().getObjectId() : ObjectId.zeroId();
        }
    }

    @AutoValue
    public static abstract class StarField {
        private static final String SEPARATOR = ":";

        public static StarField parse(String s) {
            int p = s.indexOf(SEPARATOR);
            if (p >= 0) {
                Integer id = Ints.tryParse(s.substring(0, p));
                if (id == null) {
                    return null;
                }
                Account.Id accountId = new Account.Id(id);
                String label = s.substring(p + 1);
                return StarField.create(accountId, label);
            }
            return null;
        }

        public static StarField create(Account.Id accountId, String label) {
            return new AutoValue_StarredChangesUtil_StarField(accountId, label);
        }

        public abstract Account.Id accountId();

        public abstract String label();

        public String toString() {
            return this.accountId() + SEPARATOR + this.label();
        }
    }
}

