/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountConfig;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.mail.send.OutgoingEmailValidator;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class AccountsUpdate {
    private final GitRepositoryManager repoManager;
    private final GitReferenceUpdated gitRefUpdated;
    @Nullable
    private final IdentifiedUser currentUser;
    private final AllUsersName allUsersName;
    private final OutgoingEmailValidator emailValidator;
    private final PersonIdent committerIdent;
    private final MetaDataUpdateFactory metaDataUpdateFactory;

    private AccountsUpdate(GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated, @Nullable IdentifiedUser currentUser, AllUsersName allUsersName, OutgoingEmailValidator emailValidator, PersonIdent committerIdent, MetaDataUpdateFactory metaDataUpdateFactory) {
        this.repoManager = Preconditions.checkNotNull(repoManager, "repoManager");
        this.gitRefUpdated = Preconditions.checkNotNull(gitRefUpdated, "gitRefUpdated");
        this.currentUser = currentUser;
        this.allUsersName = Preconditions.checkNotNull(allUsersName, "allUsersName");
        this.emailValidator = Preconditions.checkNotNull(emailValidator, "emailValidator");
        this.committerIdent = Preconditions.checkNotNull(committerIdent, "committerIdent");
        this.metaDataUpdateFactory = Preconditions.checkNotNull(metaDataUpdateFactory, "metaDataUpdateFactory");
    }

    public Account insert(Account.Id accountId, Consumer<Account> init) throws OrmDuplicateKeyException, IOException, ConfigInvalidException {
        AccountConfig accountConfig = this.read(accountId);
        Account account = accountConfig.getNewAccount();
        init.accept(account);
        this.commitNew(accountConfig);
        return account;
    }

    public Account update(Account.Id accountId, Consumer<Account> consumer) throws IOException, ConfigInvalidException {
        return this.update(accountId, ImmutableList.of(consumer));
    }

    public Account update(Account.Id accountId, List<Consumer<Account>> consumers) throws IOException, ConfigInvalidException {
        if (consumers.isEmpty()) {
            return null;
        }
        AccountConfig accountConfig = this.read(accountId);
        Account account = accountConfig.getAccount();
        if (account != null) {
            consumers.stream().forEach(c -> c.accept(account));
            this.commit(accountConfig);
        }
        return account;
    }

    public void replace(Account account) throws IOException, ConfigInvalidException {
        AccountConfig accountConfig = this.read(account.getId());
        accountConfig.setAccount(account);
        this.commit(accountConfig);
    }

    public void delete(Account account) throws IOException {
        this.deleteByKey(account.getId());
    }

    public void deleteByKey(Account.Id accountId) throws IOException {
        this.deleteUserBranch(accountId);
    }

    private void deleteUserBranch(Account.Id accountId) throws IOException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            AccountsUpdate.deleteUserBranch(repo, this.allUsersName, this.gitRefUpdated, this.currentUser, this.committerIdent, accountId);
        }
    }

    public static void deleteUserBranch(Repository repo, Project.NameKey project, GitReferenceUpdated gitRefUpdated, @Nullable IdentifiedUser user, PersonIdent refLogIdent, Account.Id accountId) throws IOException {
        String refName = RefNames.refsUsers(accountId);
        Ref ref = repo.exactRef(refName);
        if (ref == null) {
            return;
        }
        RefUpdate ru = repo.updateRef(refName);
        ru.setExpectedOldObjectId(ref.getObjectId());
        ru.setNewObjectId(ObjectId.zeroId());
        ru.setForceUpdate(true);
        ru.setRefLogIdent(refLogIdent);
        ru.setRefLogMessage("Delete Account", true);
        RefUpdate.Result result = ru.delete();
        if (result != RefUpdate.Result.FORCED) {
            throw new IOException(String.format("Failed to delete ref %s: %s", refName, result.name()));
        }
        gitRefUpdated.fire(project, ru, user != null ? user.getAccount() : null);
    }

    private AccountConfig read(Account.Id accountId) throws IOException, ConfigInvalidException {
        try (Repository repo = this.repoManager.openRepository(this.allUsersName);){
            AccountConfig accountConfig = new AccountConfig(this.emailValidator, accountId);
            accountConfig.load(repo);
            AccountConfig accountConfig2 = accountConfig;
            return accountConfig2;
        }
    }

    private void commitNew(AccountConfig accountConfig) throws IOException {
        this.commit(accountConfig, true);
    }

    private void commit(AccountConfig accountConfig) throws IOException {
        this.commit(accountConfig, false);
    }

    private void commit(AccountConfig accountConfig, boolean allowEmptyCommit) throws IOException {
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create();){
            md.setAllowEmpty(allowEmptyCommit);
            accountConfig.commit(md);
        }
    }

    @FunctionalInterface
    private static interface MetaDataUpdateFactory {
        public MetaDataUpdate create() throws IOException;
    }

    @Singleton
    public static class User {
        private final GitRepositoryManager repoManager;
        private final GitReferenceUpdated gitRefUpdated;
        private final AllUsersName allUsersName;
        private final OutgoingEmailValidator emailValidator;
        private final Provider<PersonIdent> serverIdent;
        private final Provider<IdentifiedUser> identifiedUser;
        private final Provider<MetaDataUpdate.User> metaDataUpdateUserFactory;

        @Inject
        public User(GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated, AllUsersName allUsersName, OutgoingEmailValidator emailValidator, @GerritPersonIdent Provider<PersonIdent> serverIdent, Provider<IdentifiedUser> identifiedUser, Provider<MetaDataUpdate.User> metaDataUpdateUserFactory) {
            this.repoManager = repoManager;
            this.gitRefUpdated = gitRefUpdated;
            this.allUsersName = allUsersName;
            this.serverIdent = serverIdent;
            this.emailValidator = emailValidator;
            this.identifiedUser = identifiedUser;
            this.metaDataUpdateUserFactory = metaDataUpdateUserFactory;
        }

        public AccountsUpdate create() {
            IdentifiedUser user = this.identifiedUser.get();
            PersonIdent i = this.serverIdent.get();
            return new AccountsUpdate(this.repoManager, this.gitRefUpdated, user, this.allUsersName, this.emailValidator, this.createPersonIdent(i, user), () -> this.metaDataUpdateUserFactory.get().create(this.allUsersName));
        }

        private PersonIdent createPersonIdent(PersonIdent ident, IdentifiedUser user) {
            return user.newCommitterIdent(ident.getWhen(), ident.getTimeZone());
        }
    }

    @Singleton
    public static class Server {
        private final GitRepositoryManager repoManager;
        private final GitReferenceUpdated gitRefUpdated;
        private final AllUsersName allUsersName;
        private final OutgoingEmailValidator emailValidator;
        private final Provider<PersonIdent> serverIdent;
        private final Provider<MetaDataUpdate.Server> metaDataUpdateServerFactory;

        @Inject
        public Server(GitRepositoryManager repoManager, GitReferenceUpdated gitRefUpdated, AllUsersName allUsersName, OutgoingEmailValidator emailValidator, @GerritPersonIdent Provider<PersonIdent> serverIdent, Provider<MetaDataUpdate.Server> metaDataUpdateServerFactory) {
            this.repoManager = repoManager;
            this.gitRefUpdated = gitRefUpdated;
            this.allUsersName = allUsersName;
            this.emailValidator = emailValidator;
            this.serverIdent = serverIdent;
            this.metaDataUpdateServerFactory = metaDataUpdateServerFactory;
        }

        public AccountsUpdate create() {
            PersonIdent i = this.serverIdent.get();
            return new AccountsUpdate(this.repoManager, this.gitRefUpdated, null, this.allUsersName, this.emailValidator, i, () -> this.metaDataUpdateServerFactory.get().create(this.allUsersName));
        }
    }
}

