/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AcceptsCreate;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.CreateEmail;
import com.google.gerrit.server.account.GetEmails;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;

@Singleton
public class EmailsCollection
implements ChildCollection<AccountResource, AccountResource.Email>,
AcceptsCreate<AccountResource> {
    private final DynamicMap<RestView<AccountResource.Email>> views;
    private final GetEmails list;
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final CreateEmail.Factory createEmailFactory;

    @Inject
    EmailsCollection(DynamicMap<RestView<AccountResource.Email>> views, GetEmails list, Provider<CurrentUser> self, PermissionBackend permissionBackend, CreateEmail.Factory createEmailFactory) {
        this.views = views;
        this.list = list;
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.createEmailFactory = createEmailFactory;
    }

    @Override
    public RestView<AccountResource> list() {
        return this.list;
    }

    @Override
    public AccountResource.Email parse(AccountResource rsrc, IdString id) throws ResourceNotFoundException, PermissionBackendException, AuthException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        if ("preferred".equals(id.get())) {
            String email = rsrc.getUser().getAccount().getPreferredEmail();
            if (Strings.isNullOrEmpty(email)) {
                throw new ResourceNotFoundException(id);
            }
            return new AccountResource.Email(rsrc.getUser(), email);
        }
        if (rsrc.getUser().hasEmailAddress(id.get())) {
            return new AccountResource.Email(rsrc.getUser(), id.get());
        }
        throw new ResourceNotFoundException(id);
    }

    @Override
    public DynamicMap<RestView<AccountResource.Email>> views() {
        return this.views;
    }

    public CreateEmail create(AccountResource parent, IdString email) {
        return this.createEmailFactory.create(email.get());
    }
}

