/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.lang.reflect.Field;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GetDiffPreferences
implements RestReadView<AccountResource> {
    private static final Logger log = LoggerFactory.getLogger(GetDiffPreferences.class);
    private final Provider<CurrentUser> self;
    private final Provider<AllUsersName> allUsersName;
    private final PermissionBackend permissionBackend;
    private final GitRepositoryManager gitMgr;

    @Inject
    GetDiffPreferences(Provider<CurrentUser> self, Provider<AllUsersName> allUsersName, PermissionBackend permissionBackend, GitRepositoryManager gitMgr) {
        this.self = self;
        this.allUsersName = allUsersName;
        this.permissionBackend = permissionBackend;
        this.gitMgr = gitMgr;
    }

    public DiffPreferencesInfo apply(AccountResource rsrc) throws AuthException, ConfigInvalidException, IOException, PermissionBackendException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser())) {
            this.permissionBackend.user(this.self).check(GlobalPermission.ADMINISTRATE_SERVER);
        }
        Account.Id id = rsrc.getUser().getAccountId();
        return GetDiffPreferences.readFromGit(id, this.gitMgr, this.allUsersName.get(), null);
    }

    static DiffPreferencesInfo readFromGit(Account.Id id, GitRepositoryManager gitMgr, AllUsersName allUsersName, DiffPreferencesInfo in) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        try (Repository git = gitMgr.openRepository(allUsersName);){
            VersionedAccountPreferences p = VersionedAccountPreferences.forUser(id);
            p.load(git);
            DiffPreferencesInfo prefs = new DiffPreferencesInfo();
            ConfigUtil.loadSection(p.getConfig(), "diff", null, prefs, GetDiffPreferences.readDefaultsFromGit(git, in), in);
            DiffPreferencesInfo diffPreferencesInfo = prefs;
            return diffPreferencesInfo;
        }
    }

    static DiffPreferencesInfo readDefaultsFromGit(Repository git, DiffPreferencesInfo in) throws ConfigInvalidException, IOException {
        VersionedAccountPreferences dp = VersionedAccountPreferences.forDefault();
        dp.load(git);
        DiffPreferencesInfo allUserPrefs = new DiffPreferencesInfo();
        ConfigUtil.loadSection(dp.getConfig(), "diff", null, allUserPrefs, DiffPreferencesInfo.defaults(), in);
        return GetDiffPreferences.updateDefaults(allUserPrefs);
    }

    private static DiffPreferencesInfo updateDefaults(DiffPreferencesInfo input) {
        DiffPreferencesInfo result = DiffPreferencesInfo.defaults();
        try {
            for (Field field : input.getClass().getDeclaredFields()) {
                Object newVal;
                if (ConfigUtil.skipField(field) || (newVal = field.get(input)) == null) continue;
                field.set(result, newVal);
            }
        }
        catch (IllegalAccessException e) {
            log.warn("Cannot get default diff preferences from All-Users", e);
            return DiffPreferencesInfo.defaults();
        }
        return result;
    }
}

