/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.group.InternalGroup;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Optional;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class AccountGroupIdHandler
extends OptionHandler<AccountGroup.Id> {
    private final GroupCache groupCache;

    @Inject
    public AccountGroupIdHandler(GroupCache groupCache, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<AccountGroup.Id> setter) {
        super(parser, option, setter);
        this.groupCache = groupCache;
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        String n = params.getParameter(0);
        Optional<InternalGroup> group = this.groupCache.get(new AccountGroup.NameKey(n));
        if (!group.isPresent()) {
            throw new CmdLineException(this.owner, "Group \"" + n + "\" does not exist");
        }
        this.setter.addValue(group.get().getId());
        return 1;
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "GROUP";
    }
}

