/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.cache.mem;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.Weigher;
import com.google.gerrit.server.cache.CacheBinding;
import com.google.gerrit.server.cache.ForwardingRemovalListener;
import com.google.gerrit.server.cache.MemoryCacheFactory;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

public class DefaultMemoryCacheFactory
implements MemoryCacheFactory {
    private final Config cfg;
    private final ForwardingRemovalListener.Factory forwardingRemovalListenerFactory;

    @Inject
    DefaultMemoryCacheFactory(@GerritServerConfig Config config, ForwardingRemovalListener.Factory forwardingRemovalListenerFactory) {
        this.cfg = config;
        this.forwardingRemovalListenerFactory = forwardingRemovalListenerFactory;
    }

    @Override
    public <K, V> Cache<K, V> build(CacheBinding<K, V> def) {
        return this.create(def).build();
    }

    @Override
    public <K, V> LoadingCache<K, V> build(CacheBinding<K, V> def, CacheLoader<K, V> loader) {
        return this.create(def).build(loader);
    }

    private <K, V> CacheBuilder<K, V> create(CacheBinding<K, V> def) {
        CacheBuilder<Object, Object> builder = DefaultMemoryCacheFactory.newCacheBuilder();
        builder.recordStats();
        builder.maximumWeight(this.cfg.getLong("cache", def.name(), "memoryLimit", def.maximumWeight()));
        builder = builder.removalListener(this.forwardingRemovalListenerFactory.create(def.name()));
        Weigher<K, V> weigher = def.weigher();
        if (weigher == null) {
            weigher = DefaultMemoryCacheFactory.unitWeight();
        }
        builder.weigher(weigher);
        Long age = def.expireAfterWrite(TimeUnit.SECONDS);
        if (this.has(def.name(), "maxAge")) {
            builder.expireAfterWrite(ConfigUtil.getTimeUnit(this.cfg, "cache", def.name(), "maxAge", age != null ? age : 0L, TimeUnit.SECONDS), TimeUnit.SECONDS);
        } else if (age != null) {
            builder.expireAfterWrite(age, TimeUnit.SECONDS);
        }
        return builder;
    }

    private boolean has(String name, String var) {
        return !Strings.isNullOrEmpty(this.cfg.getString("cache", name, var));
    }

    private static <K, V> CacheBuilder<K, V> newCacheBuilder() {
        return CacheBuilder.newBuilder();
    }

    private static <K, V> Weigher<K, V> unitWeight() {
        return new Weigher<K, V>(){

            @Override
            public int weigh(K key, V value) {
                return 1;
            }
        };
    }
}

