/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.conditions.BooleanCondition;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.WorkInProgressOp;
import com.google.gerrit.server.permissions.GlobalPermission;
import com.google.gerrit.server.permissions.PermissionBackend;
import com.google.gerrit.server.permissions.PermissionBackendException;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.RetryHelper;
import com.google.gerrit.server.update.RetryingRestModifyView;
import com.google.gerrit.server.update.UpdateException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SetReadyForReview
extends RetryingRestModifyView<ChangeResource, WorkInProgressOp.Input, Response<?>>
implements UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(SetReadyForReview.class);
    private final WorkInProgressOp.Factory opFactory;
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> self;
    private final PermissionBackend permissionBackend;
    private final ProjectControl.GenericFactory projectControlFactory;

    @Inject
    SetReadyForReview(RetryHelper retryHelper, WorkInProgressOp.Factory opFactory, Provider<ReviewDb> db, Provider<CurrentUser> self, PermissionBackend permissionBackend, ProjectControl.GenericFactory projectControlFactory) {
        super(retryHelper);
        this.opFactory = opFactory;
        this.db = db;
        this.self = self;
        this.permissionBackend = permissionBackend;
        this.projectControlFactory = projectControlFactory;
    }

    @Override
    protected Response<?> applyImpl(BatchUpdate.Factory updateFactory, ChangeResource rsrc, WorkInProgressOp.Input input) throws RestApiException, UpdateException, PermissionBackendException, NoSuchProjectException, IOException {
        Change change = rsrc.getChange();
        WorkInProgressOp.checkPermissions(this.permissionBackend, this.self.get(), change, this.projectControlFactory.controlFor(rsrc.getProject(), rsrc.getUser()));
        if (!(rsrc.isUserOwner() || this.permissionBackend.user(this.self).test(GlobalPermission.ADMINISTRATE_SERVER) || this.projectControlFactory.controlFor(rsrc.getProject(), rsrc.getUser()).isOwner())) {
            throw new AuthException("not allowed to set ready for review");
        }
        if (change.getStatus() != Change.Status.NEW) {
            throw new ResourceConflictException("change is " + ChangeUtil.status(change));
        }
        if (!change.isWorkInProgress()) {
            throw new ResourceConflictException("change is not work in progress");
        }
        try (BatchUpdate bu = updateFactory.create(this.db.get(), rsrc.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            bu.addOp(rsrc.getChange().getId(), this.opFactory.create(false, input));
            bu.execute();
            Response<String> response = Response.ok("");
            return response;
        }
    }

    @Override
    public UiAction.Description getDescription(ChangeResource rsrc) {
        boolean isProjectOwner;
        try {
            isProjectOwner = this.projectControlFactory.controlFor(rsrc.getProject(), rsrc.getUser()).isOwner();
        }
        catch (NoSuchProjectException | IOException e) {
            isProjectOwner = false;
            log.error("Cannot retrieve project owner ACL", e);
        }
        return new UiAction.Description().setLabel("Start Review").setTitle("Set Ready For Review").setVisible(BooleanCondition.and(rsrc.getChange().getStatus() == Change.Status.NEW && rsrc.getChange().isWorkInProgress(), BooleanCondition.or(rsrc.isUserOwner(), BooleanCondition.or(isProjectOwner, this.permissionBackend.user(this.self).testCond(GlobalPermission.ADMINISTRATE_SERVER)))));
    }
}

