/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigResource;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class GetDiffPreferences
implements RestReadView<ConfigResource> {
    private final AllUsersName allUsersName;
    private final GitRepositoryManager gitManager;

    @Inject
    GetDiffPreferences(GitRepositoryManager gitManager, AllUsersName allUsersName) {
        this.allUsersName = allUsersName;
        this.gitManager = gitManager;
    }

    public DiffPreferencesInfo apply(ConfigResource configResource) throws BadRequestException, ResourceConflictException, IOException, ConfigInvalidException {
        return GetDiffPreferences.readFromGit(this.gitManager, this.allUsersName, null);
    }

    static DiffPreferencesInfo readFromGit(GitRepositoryManager gitMgr, AllUsersName allUsersName, DiffPreferencesInfo in) throws IOException, ConfigInvalidException, RepositoryNotFoundException {
        try (Repository git = gitMgr.openRepository(allUsersName);){
            VersionedAccountPreferences dp = VersionedAccountPreferences.forDefault();
            dp.load(git);
            DiffPreferencesInfo allUserPrefs = new DiffPreferencesInfo();
            ConfigUtil.loadSection(dp.getConfig(), "diff", null, allUserPrefs, DiffPreferencesInfo.defaults(), in);
            DiffPreferencesInfo diffPreferencesInfo = allUserPrefs;
            return diffPreferencesInfo;
        }
    }
}

