/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.common.data.GlobalCapability;
import com.google.gerrit.extensions.config.CapabilityDefinition;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.config.CapabilityConstants;
import com.google.gerrit.server.config.ConfigResource;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ListCapabilities
implements RestReadView<ConfigResource> {
    private static final Logger log = LoggerFactory.getLogger(ListCapabilities.class);
    private static final Pattern PLUGIN_NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9-]+$");
    private final DynamicMap<CapabilityDefinition> pluginCapabilities;

    @Inject
    public ListCapabilities(DynamicMap<CapabilityDefinition> pluginCapabilities) {
        this.pluginCapabilities = pluginCapabilities;
    }

    public Map<String, CapabilityInfo> apply(ConfigResource resource) throws IllegalAccessException, NoSuchFieldException {
        TreeMap<String, CapabilityInfo> output = new TreeMap<String, CapabilityInfo>();
        this.collectCoreCapabilities(output);
        this.collectPluginCapabilities(output);
        return output;
    }

    private void collectCoreCapabilities(Map<String, CapabilityInfo> output) throws IllegalAccessException, NoSuchFieldException {
        Class<?> bundleClass = CapabilityConstants.get().getClass();
        CapabilityConstants c = CapabilityConstants.get();
        for (String id : GlobalCapability.getAllNames()) {
            String name = (String)bundleClass.getField(id).get(c);
            output.put(id, new CapabilityInfo(id, name));
        }
    }

    private void collectPluginCapabilities(Map<String, CapabilityInfo> output) {
        for (String pluginName : this.pluginCapabilities.plugins()) {
            if (!PLUGIN_NAME_PATTERN.matcher(pluginName).matches()) {
                log.warn("Plugin name '{}' must match '{}' to use capabilities; rename the plugin", (Object)pluginName, (Object)PLUGIN_NAME_PATTERN.pattern());
                continue;
            }
            for (Map.Entry<String, Provider<CapabilityDefinition>> entry : this.pluginCapabilities.byPlugin(pluginName).entrySet()) {
                String id = String.format("%s-%s", pluginName, entry.getKey());
                output.put(id, new CapabilityInfo(id, entry.getValue().get().getDescription()));
            }
        }
    }

    public static class CapabilityInfo {
        public String id;
        public String name;

        public CapabilityInfo(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }
}

