/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.git.BanCommitResult;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.LockFailureException;
import com.google.gerrit.server.git.NotesBranchUtil;
import com.google.gerrit.server.project.ProjectControl;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class BanCommit {
    private final Provider<IdentifiedUser> currentUser;
    private final GitRepositoryManager repoManager;
    private final TimeZone tz;
    private NotesBranchUtil.Factory notesBranchUtilFactory;

    public static NoteMap loadRejectCommitsMap(Repository repo, RevWalk walk) throws IOException {
        try {
            Ref ref = repo.getRefDatabase().exactRef("refs/meta/reject-commits");
            if (ref == null) {
                return NoteMap.newEmptyMap();
            }
            RevCommit map = walk.parseCommit(ref.getObjectId());
            return NoteMap.read(walk.getObjectReader(), map);
        }
        catch (IOException badMap) {
            throw new IOException("Cannot load refs/meta/reject-commits", badMap);
        }
    }

    @Inject
    BanCommit(Provider<IdentifiedUser> currentUser, GitRepositoryManager repoManager, @GerritPersonIdent PersonIdent gerritIdent, NotesBranchUtil.Factory notesBranchUtilFactory) {
        this.currentUser = currentUser;
        this.repoManager = repoManager;
        this.notesBranchUtilFactory = notesBranchUtilFactory;
        this.tz = gerritIdent.getTimeZone();
    }

    /*
     * Exception decompiling
     */
    public BanCommitResult ban(ProjectControl projectControl, List<ObjectId> commitsToBan, String reason) throws PermissionDeniedException, LockFailureException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ObjectId createNoteContent(String reason, ObjectInserter inserter) throws IOException {
        String noteContent;
        String string = noteContent = reason != null ? reason : "";
        if (noteContent.length() > 0 && !noteContent.endsWith("\n")) {
            noteContent = noteContent + "\n";
        }
        return inserter.insert(3, noteContent.getBytes(StandardCharsets.UTF_8));
    }

    private PersonIdent createPersonIdent() {
        Date now = new Date();
        return this.currentUser.get().newCommitterIdent(now, this.tz);
    }

    private static String buildCommitMessage(List<ObjectId> bannedCommits, String reason) {
        StringBuilder commitMsg = new StringBuilder();
        commitMsg.append("Banning ");
        commitMsg.append(bannedCommits.size());
        commitMsg.append(" ");
        commitMsg.append(bannedCommits.size() == 1 ? "commit" : "commits");
        commitMsg.append("\n\n");
        if (reason != null) {
            commitMsg.append("Reason: ");
            commitMsg.append(reason);
            commitMsg.append("\n\n");
        }
        commitMsg.append("The following commits are banned:\n");
        StringBuilder commitList = new StringBuilder();
        for (ObjectId c : bannedCommits) {
            if (commitList.length() > 0) {
                commitList.append(",\n");
            }
            commitList.append(c.getName());
        }
        commitMsg.append((CharSequence)commitList);
        return commitMsg.toString();
    }
}

